/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mir.mathmlcanonicalization.modules;

import cz.muni.fi.mir.mathmlcanonicalization.modules.AbstractModule;
import cz.muni.fi.mir.mathmlcanonicalization.modules.DOMModule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Parent;

public class MrowNormalizer
extends AbstractModule
implements DOMModule {
    private static final String PROPERTIES_FILENAME = "MrowNormalizer.properties";
    private static final Logger LOGGER = Logger.getLogger(MrowNormalizer.class.getName());
    private static final String CHILD_COUNT_PREFIX = "childCount.";
    private static final String OPENING = "open";
    private static final String CLOSING = "close";
    private static final String WRAP_ISIDE = "wrapInside";
    private static final String WRAP_OUTSIDE = "wrapOutside";

    public MrowNormalizer() {
        this.loadProperties(PROPERTIES_FILENAME);
    }

    @Override
    public void execute(Document doc) {
        if (doc == null) {
            throw new NullPointerException("doc");
        }
        this.traverseChildrenElements(doc.getRootElement());
    }

    private void traverseChildrenElements(Element element) {
        assert (element != null);
        ArrayList children = new ArrayList(element.getChildren());
        for (Element child : children) {
            this.traverseChildrenElements(child);
        }
        if (element.getName().equals("mrow")) {
            this.checkRemoval(element);
        } else {
            this.checkAddition(element);
        }
    }

    private void checkRemoval(Element mrowElement) {
        int childCount;
        assert (mrowElement != null && mrowElement.getName().equals("mrow"));
        Parent parent = mrowElement.getParent();
        if (!(parent instanceof Element)) {
            return;
        }
        Element parentElement = (Element)parent;
        List children = mrowElement.getChildren();
        if (children.size() <= 1) {
            MrowNormalizer.removeElement(mrowElement, parentElement);
            LOGGER.log(Level.FINE, "Element {0} removed", mrowElement);
            return;
        }
        String childCountPropertyName = CHILD_COUNT_PREFIX + parentElement.getName();
        if (!this.isProperty(childCountPropertyName)) {
            return;
        }
        String childCountProperty = this.getProperty(childCountPropertyName);
        try {
            childCount = Integer.parseInt(childCountProperty);
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.WARNING, "{0} must be an integer, property ignored", childCountProperty);
            return;
        }
        if (childCount == 1 || children.size() + parentElement.getChildren().size() - 1 == childCount) {
            MrowNormalizer.removeElement(mrowElement, parentElement);
        }
    }

    private static void removeElement(Element element, Element parent) {
        assert (element != null && parent != null);
        parent.addContent(parent.indexOf((Content)element), (Collection)element.cloneContent());
        element.detach();
    }

    private Boolean isParenthesis(Element element, String propertyName) {
        assert (element != null && propertyName != null && this.isProperty(propertyName));
        if (!element.getName().equals("mo")) {
            return false;
        }
        return this.getPropertySet(propertyName).contains(element.getTextNormalize());
    }

    private void wrapFenced(List<Element> siblings, List<Element> fenced, Element opening, Element closing) {
        Element innerElement;
        assert (siblings != null && fenced != null && opening != null);
        Element parent = opening.getParentElement();
        assert (closing != null && closing.getParentElement().equals((Object)parent));
        for (Element e : fenced) {
            e.detach();
        }
        int openingIndex = parent.indexOf((Content)opening);
        if (fenced.isEmpty() || !this.isEnabled(WRAP_ISIDE)) {
            innerElement = null;
        } else if (fenced.size() == 1) {
            innerElement = fenced.get(0);
        } else {
            innerElement = new Element("mrow");
            innerElement.addContent(fenced);
            LOGGER.fine("Inner mrow added");
        }
        if (parent.getName().equals("mrow") && siblings.get(0) == opening && siblings.get(siblings.size() - 1) == closing || !this.isEnabled(WRAP_OUTSIDE)) {
            if (innerElement == null) {
                parent.addContent(openingIndex + 1, fenced);
            } else {
                parent.addContent(openingIndex + 1, (Content)innerElement);
            }
            return;
        }
        opening.detach();
        closing.detach();
        Element outerMrowElement = new Element("mrow");
        outerMrowElement.addContent((Content)opening);
        if (innerElement != null) {
            outerMrowElement.addContent((Content)innerElement);
        } else {
            outerMrowElement.addContent(fenced);
        }
        outerMrowElement.addContent((Content)closing);
        parent.addContent(openingIndex, (Content)outerMrowElement);
        LOGGER.fine("Outer mrow added");
    }

    private void checkAddition(Element element) {
        assert (element != null);
        Parent parent = element.getParent();
        if (!(parent instanceof Element)) {
            return;
        }
        Element parentElement = (Element)parent;
        List siblings = parentElement.getChildren();
        if (this.isParenthesis(element, OPENING).booleanValue()) {
            int nesting = 0;
            ArrayList<Element> fenced = new ArrayList<Element>();
            for (int i = siblings.indexOf(element) + 1; i < siblings.size(); ++i) {
                Element current = (Element)siblings.get(i);
                if (this.isParenthesis(current, OPENING).booleanValue()) {
                    ++nesting;
                } else if (this.isParenthesis(current, CLOSING).booleanValue()) {
                    if (nesting == 0) {
                        this.wrapFenced(siblings, fenced, element, current);
                        break;
                    }
                    --nesting;
                }
                fenced.add(current);
            }
        }
    }
}

