/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mir.mathmlcanonicalization.modules;

import cz.muni.fi.mir.mathmlcanonicalization.modules.Module;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

abstract class AbstractModule
implements Module {
    protected final Properties properties = new Properties();
    private static final Logger LOGGER = Logger.getLogger(AbstractModule.class.getName());
    protected static final Namespace MATHMLNS = Namespace.getNamespace((String)"http://www.w3.org/1998/Math/MathML");
    protected static final String FENCED = "mfenced";
    protected static final String IDENTIFIER = "mi";
    protected static final String MATH = "math";
    protected static final String OPERATOR = "mo";
    protected static final String OVERSCRIPT = "mover";
    protected static final String ROW = "mrow";
    protected static final String SUBSCRIPT = "msub";
    protected static final String SUPERSCRIPT = "msup";
    protected static final String SUBSUP = "msubsup";
    protected static final String UNDEROVER = "munderover";
    protected static final String UNDERSCRIPT = "munder";

    AbstractModule() {
    }

    @Override
    public String getProperty(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        String property = this.properties.getProperty(key);
        if (property == null) {
            throw new IllegalArgumentException("Property '" + key + "' not set");
        }
        return property;
    }

    @Override
    public boolean isProperty(String key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.properties.getProperty(key) != null;
    }

    @Override
    public void setProperty(String key, String value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.properties.setProperty(key, value);
    }

    public void declareProperty(String key) {
        this.properties.setProperty(key, "");
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.properties.stringPropertyNames();
    }

    protected boolean isEnabled(String key) {
        assert (key != null);
        if (this.properties.getProperty(key).equals("1") || this.properties.getProperty(key).equals("true")) {
            return true;
        }
        if (this.properties.getProperty(key).equals("0") || this.properties.getProperty(key).equals("false")) {
            return false;
        }
        throw new IllegalArgumentException("'" + this.properties.getProperty(key) + "' is not a valid boolean value of " + key);
    }

    protected Set<String> getPropertySet(String property) {
        assert (property != null && !property.isEmpty());
        return new HashSet<String>(Arrays.asList(this.getProperty(property).split(" ")));
    }

    protected boolean isOperator(Element element, String operator) {
        return this.isOperator(element) && element.getTextTrim().equals(operator);
    }

    protected boolean isOperator(Element element) {
        assert (element != null);
        return element.getName().equals(OPERATOR);
    }

    protected void replaceElement(Element toReplace, String replacementName) {
        assert (toReplace != null && replacementName != null);
        assert (!replacementName.isEmpty());
        Element parent = toReplace.getParentElement();
        assert (parent != null);
        Element replacement = new Element(replacementName, toReplace.getNamespace());
        replacement.addContent((Collection)toReplace.removeContent());
        List attributes = toReplace.getAttributes();
        while (attributes.size() > 0) {
            Attribute currentAttribute = (Attribute)attributes.get(0);
            replacement.setAttribute(currentAttribute.detach());
        }
        int parentIndex = parent.indexOf((Content)toReplace);
        parent.removeContent(parentIndex);
        parent.addContent(parentIndex, (Content)replacement);
        LOGGER.log(Level.FINE, "{0} replaced with {1}", new Object[]{toReplace, replacementName});
    }
}

