/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mir.mathmlcanonicalization.modules;

import cz.muni.fi.mir.mathmlcanonicalization.Settings;
import cz.muni.fi.mir.mathmlcanonicalization.modules.AbstractModule;
import cz.muni.fi.mir.mathmlcanonicalization.modules.ModuleException;
import cz.muni.fi.mir.mathmlcanonicalization.modules.StreamModule;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class ElementMinimizer
extends AbstractModule
implements StreamModule {
    private Set<String> removeWithChildren;
    private Set<String> removeKeepChildren;

    public ElementMinimizer() {
        this.declareProperty("remove_all");
        this.declareProperty("remove");
        this.declareProperty("keepAttributes");
        this.declareProperty("keepAttributes.mfrac");
        this.declareProperty("keepAttributes.cn");
        this.declareProperty("keepAttributes.ci");
        this.declareProperty("keepAttributes.set");
        this.declareProperty("keepAttributes.tendsto");
        this.declareProperty("keepAttributes.interval");
        this.declareProperty("keepAttributes.declare");
        this.declareProperty("keepAttributes.mfenced");
    }

    @Override
    public ByteArrayOutputStream execute(InputStream input) throws ModuleException {
        if (input == null) {
            throw new NullPointerException("input");
        }
        this.removeWithChildren = this.getPropertySet("remove_all");
        this.removeKeepChildren = this.getPropertySet("remove");
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            this.minimizeElements(input, output);
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "error while parsing the input file. ", ex);
            throw new ModuleException("Error while parsing the input file", ex);
        }
        return output;
    }

    private boolean keepAttribute(String name, String attributeName, String attributeValue) {
        assert (name != null && attributeName != null && attributeValue != null);
        assert (!name.isEmpty() && !attributeName.isEmpty());
        String property = this.getProperty("keepAttributes");
        String elementPropertyName = "keepAttributes." + name;
        if (this.isProperty(elementPropertyName)) {
            property = property + " " + this.getProperty(elementPropertyName);
        }
        List<String> whitelist = Arrays.asList(property.split(" "));
        for (String attribute : whitelist) {
            if (!attributeName.equals(attribute) && (!attribute.contains("=") || !attributeName.equals(attribute.substring(0, attribute.lastIndexOf(61))) || !attributeValue.equals(attribute.substring(attribute.lastIndexOf(61) + 1)))) continue;
            return true;
        }
        return false;
    }

    private void minimizeElements(InputStream input, OutputStream outputStream) throws XMLStreamException {
        assert (input != null && outputStream != null);
        XMLInputFactory inputFactory = Settings.setupXMLInputFactory();
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        XMLStreamReader reader = inputFactory.createXMLStreamReader(input);
        XMLStreamWriter writer = outputFactory.createXMLStreamWriter(outputStream, "UTF-8");
        writer.writeStartDocument(reader.getEncoding(), reader.getVersion());
        int depth = 0;
        boolean mathElement = false;
        while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    int index;
                    String name = reader.getLocalName();
                    if (name.equals("math")) {
                        mathElement = true;
                    }
                    if (mathElement) {
                        if (this.removeKeepChildren.contains(name)) break;
                        if (this.removeWithChildren.contains(name)) {
                            ++depth;
                        }
                        if (depth > 0) break;
                    }
                    writer.writeStartElement(reader.getName().getPrefix(), name, reader.getName().getNamespaceURI());
                    for (index = 0; index < reader.getAttributeCount(); ++index) {
                        String attributeName = reader.getAttributeLocalName(index);
                        String attributeValue = reader.getAttributeValue(index);
                        String attributePrefix = reader.getAttributePrefix(index);
                        String attributeNamespace = reader.getAttributeNamespace(index);
                        if (mathElement && (!mathElement || !this.keepAttribute(name, attributeName, attributeValue))) continue;
                        if (attributeNamespace == null) {
                            writer.writeAttribute(attributeName, attributeValue);
                            continue;
                        }
                        writer.writeAttribute(attributePrefix, attributeNamespace, attributeName, attributeValue);
                    }
                    for (index = 0; index < reader.getNamespaceCount(); ++index) {
                        writer.writeNamespace(reader.getNamespacePrefix(index), reader.getNamespaceURI(index));
                    }
                    break;
                }
                case 2: {
                    String name;
                    if (mathElement) {
                        name = reader.getLocalName();
                        if (name.equals("math")) {
                            mathElement = false;
                        }
                        if (this.removeKeepChildren.contains(name)) break;
                        if (depth > 0) {
                            if (!this.removeWithChildren.contains(name)) break;
                            --depth;
                            break;
                        }
                    }
                    writer.writeEndElement();
                    break;
                }
                case 4: {
                    if (depth > 0) break;
                    writer.writeCharacters(reader.getText());
                    break;
                }
                case 8: {
                    writer.writeEndDocument();
                    break;
                }
                case 11: {
                    writer.writeDTD(reader.getText());
                    break;
                }
            }
        }
        writer.flush();
        writer.close();
    }
}

