/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mir.mathmlcanonicalization.modules;

import cz.muni.fi.mir.mathmlcanonicalization.modules.AbstractModule;
import cz.muni.fi.mir.mathmlcanonicalization.modules.DOMModule;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class FunctionNormalizer
extends AbstractModule
implements DOMModule {
    private static final Logger LOGGER = Logger.getLogger(FunctionNormalizer.class.getName());
    private static final String APPLY_FUNCTION_OPERATORS = "functionoperators";

    public FunctionNormalizer() {
        this.declareProperty(APPLY_FUNCTION_OPERATORS);
    }

    @Override
    public void execute(Document doc) {
        if (doc == null) {
            throw new NullPointerException("doc");
        }
        this.normalizeFunctionApplication(doc.getRootElement(), this.getPropertySet(APPLY_FUNCTION_OPERATORS));
    }

    private void normalizeFunctionApplication(Element element, Collection<String> functionOperators) {
        assert (element != null && functionOperators != null);
        List children = element.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            if (this.isFunction(i, children, functionOperators)) {
                int parameterPosition = i + 2;
                Element parameter = (Element)children.get(parameterPosition);
                Element newParameter = new Element("mrow", MATHMLNS);
                if (parameter.getName().equals("mrow")) {
                    if (this.hasInsideBrackets(parameter)) {
                        ((Element)children.get(i + 1)).detach();
                    } else {
                        parameter.addContent(1, (Content)new Element("mo", MATHMLNS).setText("("));
                        parameter.addContent((Content)new Element("mo", MATHMLNS).setText(")"));
                        LOGGER.fine("Parentheses around function argument added");
                        ((Element)children.get(i + 1)).detach();
                    }
                    LOGGER.fine("Function application operator removed");
                    continue;
                }
                if (this.isOperator(parameter, "(")) {
                    int bracketsDepth = 1;
                    newParameter.addContent((Content)parameter.detach());
                    while (parameterPosition < children.size() && bracketsDepth > 0) {
                        parameter = (Element)children.get(parameterPosition);
                        if (this.isOperator(parameter, "(")) {
                            ++bracketsDepth;
                        } else if (this.isOperator(parameter, ")")) {
                            --bracketsDepth;
                        }
                        newParameter.addContent((Content)parameter.detach());
                    }
                    while (bracketsDepth > 0) {
                        newParameter.addContent((Content)new Element("mo", MATHMLNS).setText(")"));
                        LOGGER.fine("Added missing )");
                        --bracketsDepth;
                    }
                } else {
                    newParameter.addContent((Content)new Element("mo", MATHMLNS).setText("("));
                    newParameter.addContent((Content)((Element)children.get(parameterPosition)).detach());
                    newParameter.addContent((Content)new Element("mo", MATHMLNS).setText(")"));
                    LOGGER.fine("Function argument wrapped with parentheses and mrow");
                }
                children.set(i + 1, newParameter);
                LOGGER.fine("Function application operator removed");
                continue;
            }
            this.normalizeFunctionApplication((Element)children.get(i), functionOperators);
        }
    }

    private boolean isFunction(int i, List<Element> children, Collection<String> functionOperators) {
        assert (i >= 0 && children != null && i < children.size() && functionOperators != null);
        return i < children.size() - 2 && children.get(i).getName().equals("mi") && this.isOperator(children.get(i + 1)) && functionOperators.contains(children.get(i + 1).getTextTrim());
    }

    private boolean hasInsideBrackets(Element element) {
        assert (element != null);
        List children = element.getChildren();
        if (children.size() > 1 && this.isOperator((Element)children.get(0), "(")) {
            int bracketsDepth = 1;
            for (int i = 1; i < children.size(); ++i) {
                Element child = (Element)children.get(i);
                if (this.isOperator(child, "(")) {
                    ++bracketsDepth;
                } else if (this.isOperator(child, ")")) {
                    --bracketsDepth;
                }
                if (bracketsDepth != 0) continue;
                if (i < children.size() - 1) {
                    return false;
                }
                if (i != children.size() - 1) continue;
                return true;
            }
        }
        return false;
    }
}

