/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mir.mathmlcanonicalization.modules;

import cz.muni.fi.mir.mathmlcanonicalization.modules.AbstractModule;
import cz.muni.fi.mir.mathmlcanonicalization.modules.DOMModule;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Text;
import org.jdom2.filter.ContentFilter;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;

public class OperatorNormalizer
extends AbstractModule
implements DOMModule {
    private static final Logger LOGGER = Logger.getLogger(OperatorNormalizer.class.getName());
    private static final String REMOVE_EMPTY_OPERATORS = "removeempty";
    private static final String OPERATORS_TO_REMOVE = "removeoperators";
    private static final String OPERATOR_REPLACEMENTS = "replaceoperators";
    private static final String COLON_REPLACEMENT = "colonreplacement";
    private static final String NORMALIZATION_FORM = "normalizationform";
    private static final String OPERATORS = "operators";
    private static final String IDENTIFIERS = "identifiers";

    public OperatorNormalizer() {
        this.declareProperty(REMOVE_EMPTY_OPERATORS);
        this.declareProperty(OPERATORS_TO_REMOVE);
        this.declareProperty(OPERATOR_REPLACEMENTS);
        this.declareProperty(COLON_REPLACEMENT);
        this.declareProperty(NORMALIZATION_FORM);
        this.declareProperty(OPERATORS);
        this.declareProperty(IDENTIFIERS);
    }

    @Override
    public void execute(Document doc) {
        if (doc == null) {
            throw new NullPointerException("doc");
        }
        Element root = doc.getRootElement();
        String normalizerFormStr = this.getProperty(NORMALIZATION_FORM);
        if (normalizerFormStr.isEmpty()) {
            LOGGER.fine("Unicode text normalization is switched off");
        } else {
            try {
                Normalizer.Form normalizerForm = Normalizer.Form.valueOf(normalizerFormStr);
                this.normalizeUnicode(root, normalizerForm);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Invalid configuration value: normalizationform", ex);
            }
        }
        this.unifyOperators(root);
    }

    private void unifyOperators(Element ancestor) {
        assert (ancestor != null);
        Set<String> toRemove = this.getPropertySet(OPERATORS_TO_REMOVE);
        Map<String, String> replaceMap = this.getPropertyMap(OPERATOR_REPLACEMENTS);
        if (!this.getProperty(COLON_REPLACEMENT).isEmpty()) {
            replaceMap.put(":", this.getProperty(COLON_REPLACEMENT));
        }
        Set<String> operators = this.getPropertySet(OPERATORS);
        operators.addAll(toRemove);
        operators.addAll(replaceMap.keySet());
        operators.addAll(replaceMap.values());
        this.replaceIdentifiers(ancestor, operators);
        if (this.isEnabled(REMOVE_EMPTY_OPERATORS) || !toRemove.isEmpty()) {
            this.removeSpareOperators(ancestor, toRemove);
        } else {
            LOGGER.fine("No operators set for removal");
        }
        if (replaceMap.isEmpty()) {
            LOGGER.fine("No operators set to replace");
        } else {
            this.replaceOperators(ancestor, replaceMap);
        }
        Set<String> identifiers = this.getPropertySet(IDENTIFIERS);
        this.operatorsToIdentifiers(ancestor, identifiers);
    }

    private void normalizeUnicode(Element ancestor, Normalizer.Form form) {
        assert (ancestor != null && form != null);
        ArrayList<Text> texts = new ArrayList<Text>();
        ContentFilter textFilter = new ContentFilter(4);
        for (Content content : ancestor.getContent((Filter)textFilter)) {
            texts.add((Text)content);
        }
        for (Element element : ancestor.getDescendants((Filter)new ElementFilter())) {
            for (Content text : element.getContent((Filter)textFilter)) {
                texts.add((Text)text);
            }
        }
        for (Text text : texts) {
            if (Normalizer.isNormalized(text.getText(), form)) continue;
            String normalizedString = Normalizer.normalize(text.getText(), form);
            LOGGER.log(Level.FINE, "Text ''{0}'' normalized to ''{1}''", new Object[]{text.getText(), normalizedString});
            text.setText(normalizedString);
            assert (Normalizer.isNormalized(text.getText(), form));
        }
    }

    private void removeSpareOperators(Element element, Collection<String> spareOperators) {
        assert (element != null && spareOperators != null && !spareOperators.isEmpty());
        List children = element.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Element actual = (Element)children.get(i);
            if (this.isOperator(actual)) {
                String parent = actual.getParentElement().getName();
                if (!this.isSpareOperator(actual, spareOperators) || parent.equals("msub") || parent.equals("msubsup") && !parent.equals("msup")) continue;
                actual.detach();
                --i;
                LOGGER.log(Level.FINE, "Operator {0} removed", actual);
                continue;
            }
            this.removeSpareOperators(actual, spareOperators);
        }
    }

    private boolean isSpareOperator(Element operator, Collection<String> spareOperators) {
        assert (operator != null && spareOperators != null && this.isOperator(operator));
        return this.isEnabled(REMOVE_EMPTY_OPERATORS) && operator.getText().isEmpty() || spareOperators.contains(operator.getTextTrim());
    }

    private void replaceOperators(Element element, Map<String, String> replacements) {
        assert (element != null && replacements != null);
        ArrayList<Element> operatorsToReplace = new ArrayList<Element>();
        for (Element operator : element.getDescendants((Filter)new ElementFilter("mo", MATHMLNS))) {
            if (!replacements.containsKey(operator.getTextTrim())) continue;
            operatorsToReplace.add(operator);
        }
        for (Element operator : operatorsToReplace) {
            String oldOperator = operator.getTextTrim();
            String newOperator = replacements.get(oldOperator);
            operator.setText(newOperator);
            LOGGER.log(Level.FINE, "Operator ''{0}'' was replaced by ''{1}''", new Object[]{oldOperator, newOperator});
        }
    }

    private void replaceIdentifiers(Element ancestor, Set<String> operators) {
        assert (ancestor != null && operators != null);
        ArrayList<Element> toReplace = new ArrayList<Element>();
        for (Element element : ancestor.getDescendants((Filter)new ElementFilter("mi", MATHMLNS))) {
            if (!operators.contains(element.getTextTrim())) continue;
            toReplace.add(element);
        }
        for (Element element : toReplace) {
            LOGGER.log(Level.FINE, "Creating an operator from {0}", element.getText());
            this.replaceElement(element, "mo");
        }
    }

    private void operatorsToIdentifiers(Element ancestor, Set<String> identifiers) {
        assert (ancestor != null && identifiers != null);
        ArrayList<Element> toReplace = new ArrayList<Element>();
        for (Element element : ancestor.getDescendants((Filter)new ElementFilter("mo", MATHMLNS))) {
            if (!identifiers.contains(element.getTextTrim())) continue;
            toReplace.add(element);
        }
        for (Element element : toReplace) {
            LOGGER.log(Level.FINE, "Creating an identifier from {0}", element.getText());
            this.replaceElement(element, "mi");
        }
    }

    private Map<String, String> getPropertyMap(String property) {
        String[] mappings;
        assert (property != null && this.isProperty(property));
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (String mapping : mappings = this.getProperty(property).split(" ")) {
            String[] mappingPair = mapping.split(":", 2);
            if (mappingPair.length != 2) {
                throw new IllegalArgumentException("property has wrong format");
            }
            propertyMap.put(mappingPair[0], mappingPair[1]);
        }
        return propertyMap;
    }
}

