/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mir.mathmlcanonicalization.modules;

import cz.muni.fi.mir.mathmlcanonicalization.modules.AbstractModule;
import cz.muni.fi.mir.mathmlcanonicalization.modules.DOMModule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;

public class ScriptNormalizer
extends AbstractModule
implements DOMModule {
    private static final Logger LOGGER = Logger.getLogger(ScriptNormalizer.class.getName());
    private static final String SWAP_SCRIPTS = "swapscripts";
    private static final String SPLIT_SCRIPTS_ELEMENTS = "splitscriptselements";
    private static final String UNIFY_SCRIPTS = "unifyscripts";

    public ScriptNormalizer() {
        this.declareProperty(SWAP_SCRIPTS);
        this.declareProperty(SPLIT_SCRIPTS_ELEMENTS);
        this.declareProperty(UNIFY_SCRIPTS);
    }

    @Override
    public void execute(Document doc) {
        Set<String> chosenElements;
        if (doc == null) {
            throw new NullPointerException("doc");
        }
        Element root = doc.getRootElement();
        if (this.isEnabled(UNIFY_SCRIPTS)) {
            HashMap<String, String> replaceMap = new HashMap<String, String>();
            replaceMap.put("munder", "msub");
            replaceMap.put("mover", "msup");
            replaceMap.put("munderover", "msubsup");
            this.replaceDescendants(root, replaceMap);
        }
        if (this.isEnabled(SWAP_SCRIPTS)) {
            this.normalizeSupInSub(root);
        }
        if ((chosenElements = this.getPropertySet(SPLIT_SCRIPTS_ELEMENTS)).isEmpty()) {
            LOGGER.fine("Msubsup conversion is switched off");
        } else {
            this.normalizeMsubsup(root, chosenElements);
        }
    }

    private void normalizeSupInSub(Element element) {
        assert (element != null);
        List children = element.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Element actual = (Element)children.get(i);
            this.normalizeSupInSub(actual);
            if (!actual.getName().equals("msub")) continue;
            List subscriptChildren = actual.getChildren();
            if (subscriptChildren.size() != 2) {
                LOGGER.info("Invalid msub, skipped");
                continue;
            }
            if (!((Element)subscriptChildren.get(0)).getName().equals("msup")) continue;
            List superscriptChildren = ((Element)subscriptChildren.get(0)).getChildren();
            if (superscriptChildren.size() != 2) {
                LOGGER.info("Invalid msup, skipped");
                continue;
            }
            Element newMsub = new Element("msub", MATHMLNS);
            newMsub.addContent((Content)((Element)superscriptChildren.get(0)).detach());
            newMsub.addContent((Content)((Element)subscriptChildren.get(1)).detach());
            Element newMsup = new Element("msup", MATHMLNS);
            newMsup.addContent((Content)newMsub);
            newMsup.addContent((Content)((Element)superscriptChildren.get(0)).detach());
            children.set(i, newMsup);
            LOGGER.fine("Sub/sup scripts swapped");
        }
    }

    private void normalizeMsubsup(Element element, Collection<String> firstChildren) {
        assert (element != null && firstChildren != null);
        List children = element.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Element actual = (Element)children.get(i);
            if (actual.getName().equals("msubsup")) {
                List actualChildren = actual.getChildren();
                if (actualChildren.size() != 3) {
                    LOGGER.info("Invalid msubsup, skipped");
                    continue;
                }
                if (!firstChildren.contains(((Element)actualChildren.get(0)).getName())) continue;
                Element newMsub = new Element("msub", MATHMLNS);
                newMsub.addContent((Content)((Element)actualChildren.get(0)).detach());
                newMsub.addContent((Content)((Element)actualChildren.get(0)).detach());
                Element newMsup = new Element("msup", MATHMLNS);
                newMsup.addContent((Content)newMsub);
                newMsup.addContent((Content)((Element)actualChildren.get(0)).detach());
                children.set(i, newMsup);
                --i;
                LOGGER.fine("Msubsup converted to nested msub and msup");
                continue;
            }
            this.normalizeMsubsup(actual, firstChildren);
        }
    }

    private void replaceDescendants(Element ancestor, Map<String, String> map) {
        assert (ancestor != null && map != null);
        ArrayList<Element> toReplace = new ArrayList<Element>();
        for (Element element : ancestor.getDescendants((Filter)new ElementFilter())) {
            if (!map.containsKey(element.getName())) continue;
            toReplace.add(element);
        }
        for (Element element : toReplace) {
            this.replaceElement(element, map.get(element.getName()));
        }
    }
}

