/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mir.mathmlunificator;

import cz.muni.fi.mir.mathmlunificator.MathMLUnificator;
import cz.muni.fi.mir.mathmlunificator.utils.DOMBuilder;
import cz.muni.fi.mir.mathmlunificator.utils.XMLOut;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MathMLUnificatorCommandLineTool {
    private static final String JARFILE = "mathml-unificator.jar";
    private static boolean operatorUnification = false;

    public static void main(String[] argv) throws ParserConfigurationException {
        Options options = new Options();
        options.addOption("p", "operator-unification", false, "unify operator in addition to other types of nodes");
        options.addOption("h", "help", false, "print help");
        DefaultParser parser = new DefaultParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, argv);
        }
        catch (ParseException ex) {
            MathMLUnificatorCommandLineTool.printHelp(options);
            System.exit(1);
        }
        if (line != null) {
            List<String> arguments;
            if (line.hasOption('h')) {
                MathMLUnificatorCommandLineTool.printHelp(options);
                System.exit(0);
            }
            if (line.hasOption('p')) {
                operatorUnification = true;
            }
            if ((arguments = Arrays.asList(line.getArgs())).size() > 0) {
                Document outerDocument = DOMBuilder.getDocumentBuilder().newDocument();
                Element rootNode = outerDocument.createElementNS("http://mir.fi.muni.cz/mathml-unification/", "uni:unified-math-batch");
                outerDocument.appendChild(rootNode);
                for (String filepath : arguments) {
                    try {
                        Document doc = DOMBuilder.buildDocFromFilepath(filepath);
                        MathMLUnificator.unifyMathML(doc, operatorUnification);
                        if (arguments.size() == 1) {
                            XMLOut.xmlStdoutSerializer(doc);
                            continue;
                        }
                        Element itemNode = rootNode.getOwnerDocument().createElementNS("http://mir.fi.muni.cz/mathml-unification/", "uni:unified-math-batch-item");
                        Attr filenameAttr = itemNode.getOwnerDocument().createAttributeNS("http://mir.fi.muni.cz/mathml-unification/", "uni:input-file");
                        filenameAttr.setTextContent(String.valueOf(filepath));
                        itemNode.setAttributeNodeNS(filenameAttr);
                        itemNode.appendChild(rootNode.getOwnerDocument().importNode(doc.getDocumentElement(), true));
                        rootNode.appendChild(itemNode);
                    }
                    catch (IOException | SAXException ex) {
                        Logger.getLogger(MathMLUnificatorCommandLineTool.class.getName()).log(Level.SEVERE, "Failed processing of file: " + filepath, ex);
                    }
                }
                if (rootNode.getChildNodes().getLength() > 0) {
                    XMLOut.xmlStdoutSerializer(rootNode.getOwnerDocument());
                }
            } else {
                MathMLUnificatorCommandLineTool.printHelp(options);
                System.exit(0);
            }
        }
    }

    private static void printHelp(Options options) {
        System.err.println("Usage:");
        System.err.println("\tjava -jar mathml-unificator.jar [ -p ] input.xml [ input.xml ... ]");
        System.err.println("\tjava -jar mathml-unificator.jar -h");
        System.err.println("Options:");
        HelpFormatter formatter = new HelpFormatter();
        formatter.printOptions(new PrintWriter(System.err, true), 80, options, 8, 8);
    }
}

