/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.fi.mir.mathmlunificator;

import cz.muni.fi.mir.mathmlunificator.DocumentParser;
import cz.muni.fi.mir.mathmlunificator.NodeLevel;
import cz.muni.fi.mir.mathmlunificator.UnificationLevel;
import cz.muni.fi.mir.mathmlunificator.config.Constants;
import cz.muni.fi.mir.mathmlunificator.utils.DOMBuilder;
import cz.muni.fi.mir.mathmlunificator.utils.MathMLTools;
import cz.muni.fi.mir.mathmlunificator.utils.XMLOut;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MathMLUnificator {
    private static final int NUMOFMINORLEVELS = 2;
    private HashMap<NodeLevel<Integer, Integer>, List> nodesByDepth;

    public static void unifyMathML(Document doc, boolean operatorUnification) {
        List<Node> mathNodes = DocumentParser.findMathMLNodes(doc);
        for (Node mathNode : mathNodes) {
            MathMLUnificator.unifyMathMLNode(mathNode, operatorUnification);
        }
    }

    public static void unifyMathML(InputStream is, OutputStream os, boolean operatorUnification) throws IOException {
        String originalDoc = IOUtils.toString((InputStream)is);
        try {
            Document doc = DOMBuilder.buildDoc(new ByteArrayInputStream(originalDoc.getBytes()));
            MathMLUnificator.unifyMathML(doc, operatorUnification);
            XMLOut.xmlSerializer(doc, os);
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            Logger.getLogger(MathMLUnificator.class.getName()).log(Level.SEVERE, "MathML Unification from string failed, input string not modified.", ex);
            IOUtils.write((String)originalDoc, (OutputStream)os);
        }
    }

    public static void unifyMathMLNode(Node mathNode, boolean operatorUnification) {
        new MathMLUnificator().unifyMathMLNodeImpl(mathNode, operatorUnification, true);
    }

    public static HashMap<Integer, Node> getUnifiedMathMLNodes(Node mathNode, boolean operatorUnification) {
        return new MathMLUnificator().unifyMathMLNodeImpl(mathNode, operatorUnification, false);
    }

    private void unifyMathMLNodeImpl(Node mathNode, boolean operatorUnification) {
        this.unifyMathMLNodeImpl(mathNode, operatorUnification, true);
    }

    private HashMap<Integer, Node> unifyMathMLNodeImpl(Node mathNode, boolean operatorUnification, boolean workInPlace) {
        Object maxLevelAttr;
        if (mathNode.getOwnerDocument() == null) {
            String msg = "The given node is not attached to any document.";
            if (mathNode.getNodeType() == 9) {
                msg = "The given node is document itself. Call with mathNode.getDocumentElement() instead.";
            }
            throw new IllegalArgumentException(msg);
        }
        this.nodesByDepth = new HashMap();
        Element unifiedMathNode = null;
        HashMap<Integer, Node> unifiedNodesList = null;
        Document unifiedMathDoc = null;
        if (workInPlace) {
            unifiedMathNode = mathNode.getOwnerDocument().createElementNS("http://mir.fi.muni.cz/mathml-unification/", "unified-math");
            mathNode.getParentNode().replaceChild(unifiedMathNode, mathNode);
            unifiedMathNode.appendChild(mathNode.cloneNode(true));
        } else {
            unifiedNodesList = new HashMap<Integer, Node>();
            unifiedMathDoc = DOMBuilder.createNewDocWithNodeClone(mathNode, true);
            mathNode = unifiedMathDoc.getDocumentElement();
        }
        this.rememberLevelsOfNodes(mathNode, operatorUnification);
        NodeLevel<Integer, Integer> level = new NodeLevel<Integer, Integer>(this.getMaxMajorNodesLevel(), 2);
        int levelAttrCounter = 0;
        LinkedList<Object> maxLevelAttrs = new LinkedList<Object>();
        while ((Integer)level.major > 0) {
            if (this.nodesByDepth.containsKey(level) && this.unifyAtLevel(level)) {
                ++levelAttrCounter;
                Node thisLevelMathNode = mathNode.cloneNode(true);
                Attr attr = thisLevelMathNode.getOwnerDocument().createAttributeNS("http://mir.fi.muni.cz/mathml-unification/", "uni:unification-level");
                maxLevelAttr = thisLevelMathNode.getOwnerDocument().createAttributeNS("http://mir.fi.muni.cz/mathml-unification/", "uni:unification-max-level");
                maxLevelAttrs.add(maxLevelAttr);
                attr.setTextContent(String.valueOf(levelAttrCounter));
                ((Element)thisLevelMathNode).setAttributeNodeNS(attr);
                ((Element)thisLevelMathNode).setAttributeNodeNS((Attr)maxLevelAttr);
                if (workInPlace) {
                    unifiedMathNode.appendChild(thisLevelMathNode);
                } else {
                    unifiedNodesList.put(levelAttrCounter, DOMBuilder.cloneNodeToNewDoc(thisLevelMathNode, true));
                }
            }
            Object object = level;
            Integer n = (Integer)((NodeLevel)object).minor;
            ((NodeLevel)object).minor = (Integer)((NodeLevel)object).minor - 1;
            maxLevelAttr = ((NodeLevel)object).minor;
            if ((Integer)level.minor > 0) continue;
            object = level;
            Integer n2 = (Integer)((NodeLevel)object).major;
            ((NodeLevel)object).major = (Integer)((NodeLevel)object).major - 1;
            maxLevelAttr = ((NodeLevel)object).major;
            level.minor = 2;
        }
        for (Attr attr : maxLevelAttrs) {
            attr.setTextContent(String.valueOf(levelAttrCounter));
        }
        if (workInPlace) {
            return null;
        }
        for (Node node : unifiedNodesList.values()) {
            maxLevelAttr = (Attr)node.getAttributes().getNamedItemNS("http://mir.fi.muni.cz/mathml-unification/", "unification-max-level");
            if (maxLevelAttr == null) continue;
            maxLevelAttr.setTextContent(String.valueOf(levelAttrCounter));
        }
        return unifiedNodesList;
    }

    private void rememberLevelsOfNodes(Node rootNode, boolean operatorUnification) {
        NodeList nodeList = rootNode.getChildNodes();
        this.rememberNodesStartingAtLevel(1, nodeList, operatorUnification);
    }

    private void rememberNodesStartingAtLevel(int level, NodeList nodeList, boolean operatorUnification) {
        if (nodeList != null && nodeList.getLength() > 0) {
            NodeLevel<Integer, Integer> levelOperators = new NodeLevel<Integer, Integer>(level, 1);
            NodeLevel<Integer, Integer> levelNonOperators = new NodeLevel<Integer, Integer>(level, 2);
            ArrayList<Node> nodesNonOperator = new ArrayList<Node>(nodeList.getLength());
            ArrayList<Node> nodesOperator = new ArrayList<Node>(nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeName().equals("mo")) {
                    if (!operatorUnification) continue;
                    nodesOperator.add(node);
                    continue;
                }
                nodesNonOperator.add(node);
            }
            this.nodesByDepth.merge(levelNonOperators, nodesNonOperator, (t, u) -> {
                t.addAll(u);
                return t;
            });
            this.nodesByDepth.merge(levelOperators, nodesOperator, (t, u) -> {
                t.addAll(u);
                return t;
            });
            for (Node node : nodesNonOperator) {
                if (node.getNodeType() != 1) continue;
                this.rememberNodesStartingAtLevel(level + 1, node.getChildNodes(), operatorUnification);
            }
        }
    }

    private boolean unifyAtLevel(NodeLevel<Integer, Integer> level) {
        boolean modified = false;
        if ((Integer)level.major <= 0) {
            throw new IllegalArgumentException("Major level must be greather than 0.");
        }
        if ((Integer)level.minor <= 0) {
            throw new IllegalArgumentException("Minor level must be greather than 0.");
        }
        if (this.nodesByDepth.containsKey(level)) {
            List nodes = this.nodesByDepth.get(level);
            for (Node node : nodes) {
                if (node.getNodeType() != 1) continue;
                MathMLUnificator.replaceNodeWithUnificator(node);
                modified = true;
            }
        }
        return modified;
    }

    public static void replaceNodeWithUnificator(Node oldNode) {
        Node parentNode = oldNode.getParentNode();
        if (parentNode == null) {
            throw new IllegalArgumentException("Cannot replace node [" + oldNode + "] that has no parent.");
        }
        if (!Constants.CMATHML_ANNOTATIONS.contains(oldNode.getNodeName())) {
            String unificatorElementType;
            String unificator = "\u25cd";
            String string = unificatorElementType = oldNode.getNodeName().equals("mo") ? "mo" : "mi";
            if (MathMLTools.isContentMathMLNode(oldNode)) {
                unificator = "\u25d0";
                unificatorElementType = Constants.CMATHML_IDENTIFIER_OR_NUMBER.contains(oldNode.getNodeName()) ? "ci" : "csymbol";
            }
            Element newNode = oldNode.getOwnerDocument().createElementNS(oldNode.getNamespaceURI(), unificatorElementType);
            newNode.setTextContent(unificator);
            parentNode.replaceChild(newNode, oldNode);
        }
    }

    private int getMaxMajorNodesLevel() {
        int maxInt = 0;
        for (NodeLevel<Integer, Integer> level : this.nodesByDepth.keySet()) {
            if (maxInt >= (Integer)level.major) continue;
            maxInt = (Integer)level.major;
        }
        return maxInt;
    }

    public static boolean isUnifiedMathNode(Node node) {
        Node uniLevel;
        if (node != null && node.getNodeType() == 1 && (node.getNamespaceURI() == null && node.getNodeName().equals("math") || node.getNamespaceURI() != null && node.getNamespaceURI().equals("http://www.w3.org/1998/Math/MathML")) && (uniLevel = node.getAttributes().getNamedItemNS("http://mir.fi.muni.cz/mathml-unification/", "unification-level")) != null && uniLevel.getNodeType() == 2) {
            Integer value;
            try {
                value = Integer.parseInt(((Attr)uniLevel).getTextContent());
            }
            catch (NumberFormatException ex) {
                return false;
            }
            if (value >= 0) {
                return true;
            }
        }
        return false;
    }

    public static UnificationLevel getNodeUnificationLevel(Node node) {
        Integer uniLevelValue = 0;
        Integer maxLevelValue = 0;
        if (node != null && node.getNodeType() == 1) {
            Node uniLevel = node.getAttributes().getNamedItemNS("http://mir.fi.muni.cz/mathml-unification/", "unification-level");
            Node maxLevel = node.getAttributes().getNamedItemNS("http://mir.fi.muni.cz/mathml-unification/", "unification-max-level");
            if (uniLevel != null && uniLevel.getNodeType() == 2 && maxLevel != null && maxLevel.getNodeType() == 2) {
                try {
                    uniLevelValue = Integer.parseInt(((Attr)uniLevel).getTextContent());
                    maxLevelValue = Integer.parseInt(((Attr)maxLevel).getTextContent());
                    if (uniLevelValue > 0 && maxLevelValue > 0) {
                        return new UnificationLevel(uniLevelValue, maxLevelValue);
                    }
                }
                catch (NumberFormatException ex) {
                    return new UnificationLevel();
                }
            }
        }
        return new UnificationLevel();
    }
}

