/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.pdfjbim;

import cz.muni.pdfjbim.PdfImageInformation;
import cz.muni.pdfjbim.PdfRecompressionException;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class PdfImage {
    private int objectNumber;
    private int generationNumber;
    private PdfImageInformation pdfImageInformation;
    private File imageDataFile;

    public PdfImage(File imageDataFile) {
        if (imageDataFile == null) {
            throw new NullPointerException("imageDataFile");
        }
        this.imageDataFile = imageDataFile;
    }

    public PdfImage(File imageData, PdfImageInformation pdfImageInformation) {
        this.imageDataFile = imageData;
        this.pdfImageInformation = pdfImageInformation;
    }

    public byte[] getImageData() throws PdfRecompressionException {
        Long sizeOfFile = this.imageDataFile.length();
        int imageSize = 0;
        FileInputStream jbImageInput = null;
        try {
            jbImageInput = new FileInputStream(this.imageDataFile);
            if (sizeOfFile > Integer.MAX_VALUE) {
                throw new PdfRecompressionException("cannot process image greater than 2147483647");
            }
            DataInputStream inputData = new DataInputStream(jbImageInput);
            imageSize = sizeOfFile.intValue();
            byte[] imageBytes = new byte[imageSize];
            inputData.readFully(imageBytes);
            return imageBytes;
        }
        catch (FileNotFoundException ex) {
            throw new PdfRecompressionException(ex);
        }
        catch (IOException ioEx) {
            throw new PdfRecompressionException("io error", ioEx);
        }
    }

    public void setPdfImageInformation(String key, int pageNum, int width, int height, int objNum, int genNum) {
        this.pdfImageInformation = new PdfImageInformation(key, width, height, objNum, genNum);
    }

    public void setPdfImageInformation(PdfImageInformation pdfImageInformation) {
        this.pdfImageInformation = pdfImageInformation;
    }

    public PdfImageInformation getPdfImageInformation() {
        return this.pdfImageInformation;
    }

    public File getImageDataFile() {
        return this.imageDataFile;
    }
}

