/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.pdfjbim;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfWriter;
import cz.muni.pdfjbim.Jbig2ForPdf;
import cz.muni.pdfjbim.PdfImage;
import cz.muni.pdfjbim.PdfImageInformation;
import cz.muni.pdfjbim.PdfObjId;
import cz.muni.pdfjbim.PdfRecompressionException;
import cz.muni.pdfjbim.Tools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfImageReplacer {
    private static final Logger log = LoggerFactory.getLogger(PdfImageReplacer.class);

    public void replaceImageUsingIText(String pdfName, OutputStream os, Jbig2ForPdf imagesData) throws PdfRecompressionException {
        try {
            this.replaceImageUsingIText(new FileInputStream(pdfName), os, imagesData);
        }
        catch (FileNotFoundException ex) {
            log.error("Original PDF not found", (Throwable)ex);
            throw new PdfRecompressionException(ex);
        }
    }

    public void replaceImageUsingIText(InputStream originalPdf, OutputStream os, Jbig2ForPdf imagesData) throws PdfRecompressionException {
        if (originalPdf == null) {
            throw new NullPointerException("pdfName");
        }
        if (os == null) {
            throw new NullPointerException("os");
        }
        if (imagesData == null) {
            throw new NullPointerException("imagesData is null => nothing to recompress");
        }
        Map<PdfObjId, PdfImage> jbig2Images = imagesData.getMapOfJbig2Images();
        PdfStamper stp = null;
        try {
            String key;
            Iterator<PdfImage> itImages;
            PdfReader pdf = new PdfReader(originalPdf);
            stp = new PdfStamper(pdf, os);
            PdfWriter writer = stp.getWriter();
            int version = Integer.parseInt(String.valueOf(pdf.getPdfVersion()));
            if (version < 4) {
                writer.setPdfVersion(PdfWriter.PDF_VERSION_1_4);
            }
            if ((itImages = jbig2Images.values().iterator()).hasNext()) {
                PdfImage myImg = itImages.next();
                key = myImg.getPdfImageInformation().getKey();
            } else {
                key = "im0";
            }
            for (int pageNum = 1; pageNum <= pdf.getNumberOfPages(); ++pageNum) {
                PRIndirectReference ref;
                PdfObjId imId;
                PdfImage jbImage;
                PdfName type;
                PdfDictionary tg;
                PdfDictionary pg = pdf.getPageN(pageNum);
                PdfDictionary resPg = (PdfDictionary)PdfReader.getPdfObject((PdfObject)pg.get(PdfName.RESOURCES));
                PdfDictionary xobjResPg = (PdfDictionary)PdfReader.getPdfObject((PdfObject)resPg.get(PdfName.XOBJECT));
                PdfObject obj = null;
                if (xobjResPg != null) {
                    Iterator it = xobjResPg.getKeys().iterator();
                    while (it.hasNext()) {
                        PdfObject pdfObjIndirect = xobjResPg.get((PdfName)it.next());
                        if (!pdfObjIndirect.isIndirect()) continue;
                        PdfDictionary pdfObj2 = (PdfDictionary)PdfReader.getPdfObject((PdfObject)pdfObjIndirect);
                        PdfDictionary xobj2Res = (PdfDictionary)PdfReader.getPdfObject((PdfObject)pdfObj2.get(PdfName.RESOURCES));
                        if (xobj2Res != null) {
                            Iterator it2 = xobj2Res.getKeys().iterator();
                            while (it2.hasNext()) {
                                PdfObject resObj = xobj2Res.get((PdfName)it2.next());
                            }
                            PdfDictionary xobj = (PdfDictionary)PdfReader.getPdfObject((PdfObject)xobj2Res.get(PdfName.XOBJECT));
                            if (xobj == null) continue;
                            obj = xobj.get(new PdfName(key));
                            continue;
                        }
                        obj = xobjResPg.get(new PdfName(key));
                        if (obj != null) continue;
                        obj = pdfObjIndirect;
                    }
                }
                if (obj == null || !obj.isIndirect() || (tg = (PdfDictionary)PdfReader.getPdfObject(obj)) == null || !PdfName.IMAGE.equals((Object)(type = (PdfName)PdfReader.getPdfObject((PdfObject)tg.get(PdfName.SUBTYPE)))) || (jbImage = jbig2Images.get(imId = new PdfObjId((ref = (PRIndirectReference)obj).getNumber(), ref.getGeneration()))) == null) continue;
                PdfImageInformation jbImageInfo = jbImage.getPdfImageInformation();
                Image img = Image.getInstance((int)jbImageInfo.getWidth(), (int)jbImageInfo.getHeight(), (byte[])jbImage.getImageData(), (byte[])imagesData.getGlobalData());
                PdfReader.killIndirect((PdfObject)obj);
                Image maskImage = img.getImageMask();
                if (maskImage != null) {
                    writer.addDirectImageSimple(maskImage);
                }
                writer.addDirectImageSimple(img, (PdfIndirectReference)((PRIndirectReference)obj));
            }
        }
        catch (IOException ioEx) {
            throw new PdfRecompressionException(ioEx);
        }
        catch (DocumentException dEx) {
            throw new PdfRecompressionException(dEx);
        }
        finally {
            try {
                if (stp != null) {
                    stp.close();
                }
            }
            catch (DocumentException ex) {
                log.error("Exception thrown while closing stream", (Throwable)ex);
            }
            catch (IOException ex) {
                log.error("Exception thrown while closing stream", (Throwable)ex);
            }
            Tools.deleteFilesFromList(imagesData.getJbFiles().toArray(new File[0]));
        }
    }
}

