/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.pdfjbim;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tools {
    private static final Logger logger = LoggerFactory.getLogger(Tools.class);

    public static void deleteFilesFromList(List<String> filesToDelete) {
        for (int i = 0; i < filesToDelete.size(); ++i) {
            File fileToDelete = new File(filesToDelete.get(i));
            if (fileToDelete.delete()) continue;
            logger.warn("problem to delete file: " + fileToDelete.getPath());
        }
    }

    public static void deleteFilesFromList(File[] filesToDelete) {
        for (int i = 0; i < filesToDelete.length; ++i) {
            File fileToDelete = filesToDelete[i];
            if (fileToDelete.delete()) continue;
            logger.warn("problem to delete file: " + fileToDelete.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File fromFile, File toFile) throws IOException {
        if (!fromFile.exists()) {
            throw new IOException("FileCopy: no such source file: " + fromFile.getName());
        }
        if (!fromFile.isFile()) {
            throw new IOException("FileCopy: can't copy directory: " + fromFile.getName());
        }
        if (!fromFile.canRead()) {
            throw new IOException("FileCopy: source file is unreadable: " + fromFile.getName());
        }
        if (toFile.isDirectory()) {
            toFile = new File(toFile, fromFile.getName());
        }
        if (toFile.exists()) {
            if (!toFile.canWrite()) {
                throw new IOException("FileCopy: destination file is unwriteable: " + toFile.getName());
            }
            logger.info("Overwrite existing file " + toFile.getName());
        } else {
            File dir;
            String parent = toFile.getParent();
            if (parent == null) {
                parent = System.getProperty("user.dir");
            }
            if (!(dir = new File(parent)).exists()) {
                throw new IOException("FileCopy: destination directory doesn't exist: " + parent);
            }
            if (dir.isFile()) {
                throw new IOException("FileCopy: destination is not a directory: " + parent);
            }
            if (!dir.canWrite()) {
                throw new IOException("FileCopy: destination directory is unwriteable: " + parent);
            }
        }
        FileInputStream from = null;
        FileOutputStream to = null;
        try {
            int bytesRead;
            from = new FileInputStream(fromFile);
            to = new FileOutputStream(toFile);
            byte[] buffer = new byte[4096];
            while ((bytesRead = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytesRead);
            }
        }
        finally {
            if (from != null) {
                try {
                    from.close();
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
            }
            if (to != null) {
                try {
                    to.close();
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    public static void copyDir(File sourceDir, File destinationDir) throws IOException {
        if (sourceDir == null) {
            throw new NullPointerException("sourceDir");
        }
        if (destinationDir == null) {
            throw new NullPointerException("toDir");
        }
        if (!sourceDir.exists() || !destinationDir.exists()) {
            throw new IllegalArgumentException(sourceDir.getPath() + " or " + destinationDir.getPath() + " doesn't exist");
        }
        if (!sourceDir.isDirectory()) {
            throw new IllegalArgumentException(sourceDir.getPath() + " is not a directory");
        }
        if (!destinationDir.isDirectory()) {
            throw new IllegalArgumentException(destinationDir.getPath() + " is not a directory");
        }
        File[] sourceFiles = sourceDir.listFiles();
        for (int i = 0; i < sourceFiles.length; ++i) {
            if (sourceFiles[i].isDirectory()) continue;
            Tools.copy(sourceFiles[i], destinationDir);
        }
    }
}

