/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.pdfjbim;

import cz.muni.pdfjbim.PdfRecompressionException;
import cz.muni.pdfjbim.Tools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jbig2enc {
    private static final Logger log = LoggerFactory.getLogger(Jbig2enc.class);
    private String jbig2enc;
    private double defaultThresh = 0.85;
    private boolean autoThresh = false;
    private int bwThresh = 188;
    private boolean useOcr = false;
    private String lang = null;
    private boolean forced = false;

    public Jbig2enc(String jbig2enc) {
        if (jbig2enc == null) {
            throw new NullPointerException("No path to encoder given!");
        }
        this.jbig2enc = jbig2enc;
    }

    public Jbig2enc() {
        this.jbig2enc = "jbig2";
    }

    public boolean isForcedOcrForUnknownResolution() {
        return this.forced;
    }

    public void setForcedOcrForUnknownResolution(boolean forced) {
        this.forced = forced;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public boolean isAutoThresh() {
        return this.autoThresh;
    }

    public void setAutoThresh(boolean autoThresh) {
        this.autoThresh = autoThresh;
    }

    public int getBwThresh() {
        return this.bwThresh;
    }

    public void setBwThresh(int bwThresh) {
        if (bwThresh < 0 || bwThresh > 255) {
            throw new IllegalArgumentException("bwThresh");
        }
        this.bwThresh = bwThresh;
    }

    public double getDefaultThresh() {
        return this.defaultThresh;
    }

    public void setDefaultThresh(double defaultThresh) {
        if (defaultThresh < 0.4 || defaultThresh > 0.9) {
            throw new IllegalArgumentException("defaultThresh");
        }
        this.defaultThresh = defaultThresh;
    }

    public String getJbig2enc() {
        return this.jbig2enc;
    }

    public void setJbig2enc(String jbig2enc) {
        this.jbig2enc = jbig2enc;
    }

    public boolean isUseOcr() {
        return this.useOcr;
    }

    public void setUseOcr(boolean useOcr) {
        this.useOcr = useOcr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(List<String> imageList, String basename) throws PdfRecompressionException {
        if (basename == null) {
            basename = "output";
        }
        if (imageList == null) {
            throw new NullPointerException("imageList");
        }
        if (imageList.isEmpty()) {
            log.info("there are no images for running jbig2enc at (given list is empty)");
            return;
        }
        ArrayList<String> toRun = new ArrayList<String>();
        toRun.add(this.jbig2enc);
        toRun.add("-s");
        toRun.add("-p");
        toRun.add("-b");
        toRun.add(basename);
        toRun.add("-t");
        toRun.add(String.valueOf(this.defaultThresh));
        toRun.add("-T");
        toRun.add(String.valueOf(this.bwThresh));
        if (this.autoThresh) {
            toRun.add("-autoThresh");
            if (this.useOcr) {
                toRun.add("-useOcr");
                if (this.lang != null) {
                    toRun.add("-lang");
                    toRun.add(this.lang);
                }
            }
        }
        if (this.forced) {
            toRun.add("-ff");
        }
        toRun.addAll(imageList);
        String[] run = new String[toRun.size()];
        run = toRun.toArray(run);
        Runtime runtime = Runtime.getRuntime();
        try {
            String line;
            log.debug("Executing {}", toRun);
            Process pr1 = runtime.exec(run);
            InputStream erStream = pr1.getErrorStream();
            int exitValue = pr1.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(erStream));
            while ((line = reader.readLine()) != null) {
                log.debug(line);
            }
            if (exitValue != 0) {
                log.warn("jbig2enc ended with error " + exitValue);
                Tools.deleteFilesFromList(imageList);
                throw new PdfRecompressionException("jbig2enc ended with error " + exitValue);
            }
        }
        catch (IOException ex) {
            log.warn("running jbig2enc caused IOException", (Throwable)ex);
        }
        catch (InterruptedException ex2) {
            log.warn("running jbig2enc was interupted", (Throwable)ex2);
        }
        finally {
            Tools.deleteFilesFromList(imageList);
        }
    }
}

