/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.pdfjbim;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.parser.PdfReaderContentParser;
import com.itextpdf.text.pdf.parser.RenderListener;
import cz.muni.pdfjbim.PdfImageInformation;
import cz.muni.pdfjbim.PdfRecompressionException;
import cz.muni.pdfjbim.Tools;
import cz.muni.pdfjbim.pdf.MyImageRenderListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectForm;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfImageExtractor {
    private int imageCounter = 1;
    private List<String> namesOfImages = new ArrayList<String>();
    private List<PdfImageInformation> originalImageInformations = new ArrayList<PdfImageInformation>();
    private static final Logger log = LoggerFactory.getLogger(PdfImageExtractor.class);
    private static final String TMP_DIR = System.getProperty("java.io.tmpdir");

    public List<String> getNamesOfImages() {
        return this.namesOfImages;
    }

    public List<PdfImageInformation> getOriginalImageInformations() {
        return this.originalImageInformations;
    }

    public void extractImages(File pdfFile, String password, Set<Integer> pagesToProcess, Boolean binarize) throws PdfRecompressionException {
        if (binarize == null) {
            binarize = false;
        }
        if (pdfFile == null) {
            throw new IllegalArgumentException("pdfFile");
        }
        String prefix = null;
        if (prefix == null && pdfFile.length() > 4L) {
            String fileName = pdfFile.getName();
            prefix = fileName.substring(0, fileName.length() - 4);
        }
        try {
            FileInputStream is = new FileInputStream(pdfFile);
            this.extractImagesUsingPdfParser(is, prefix, password, pagesToProcess, binarize);
        }
        catch (FileNotFoundException ex) {
            throw new PdfRecompressionException("File doesn't exist", ex);
        }
    }

    public void extractImages(String pdfFile, String password, Set<Integer> pagesToProcess, Boolean binarize) throws PdfRecompressionException {
        if (binarize == null) {
            binarize = false;
        }
        if (pdfFile == null) {
            throw new IllegalArgumentException(pdfFile);
        }
        String prefix = null;
        if (prefix == null && pdfFile.length() > 4) {
            prefix = pdfFile.substring(0, pdfFile.length() - 4);
        }
        try {
            FileInputStream is = new FileInputStream(pdfFile);
            this.extractImagesUsingPdfParser(is, prefix, password, pagesToProcess, binarize);
        }
        catch (FileNotFoundException ex) {
            throw new PdfRecompressionException("File doesn't exist", ex);
        }
    }

    public void extractImages(InputStream is, String password, Set<Integer> pagesToProcess, Boolean binarize) throws PdfRecompressionException {
        if (binarize == null) {
            binarize = false;
        }
        String prefix = PdfImageExtractor.class.getName();
        this.extractImagesUsingPdfParser(is, prefix, password, pagesToProcess, binarize);
    }

    public static void extractImages(String filename) throws IOException, DocumentException {
        PdfReader reader = new PdfReader(filename);
        PdfReaderContentParser parser = new PdfReaderContentParser(reader);
        MyImageRenderListener listener = new MyImageRenderListener("Img%s.%s");
        for (int i = 1; i <= reader.getNumberOfPages(); ++i) {
            parser.processContent(i, (RenderListener)listener);
        }
    }

    public void extractJbig2Images(InputStream is) throws PdfRecompressionException {
        if (is == null) {
            throw new IllegalArgumentException("InputStream not given");
        }
        PdfReader pdfReader = null;
        try {
            pdfReader = new PdfReader(is);
            for (int i = 0; i <= pdfReader.getNumberOfPages(); ++i) {
                PdfDictionary d = pdfReader.getPageN(i);
                PdfIndirectReference ir = d.getAsIndirectObject(PdfName.CONTENTS);
                PdfObject o = pdfReader.getPdfObject(ir.getNumber());
                PdfStream stream = (PdfStream)o;
                PdfObject pdfsubtype = stream.get(PdfName.SUBTYPE);
                if (pdfsubtype == null || !pdfsubtype.toString().equals(PdfName.IMAGE.toString())) continue;
                byte[] img = PdfReader.getStreamBytesRaw((PRStream)((PRStream)stream));
                FileOutputStream out = new FileOutputStream(new File("pdfRecompressor", String.format("%1$05d", i) + ".jpg"));
                ((OutputStream)out).write(img);
                out.flush();
                ((OutputStream)out).close();
            }
        }
        catch (IOException ex) {
            log.error("IOException caught while trying to extract jbig2 images from PDF", (Throwable)ex);
            throw new PdfRecompressionException("IOException caught while trying to extract jbig2 images from PDF", ex);
        }
        finally {
            if (pdfReader != null) {
                pdfReader.close();
            }
        }
    }

    private List<Image> GetImagesFromPdfDict(PdfDictionary dict, PdfReader doc) throws IOException {
        ArrayList<Image> images = new ArrayList<Image>();
        PdfDictionary res = (PdfDictionary)PdfReader.getPdfObject((PdfObject)dict.get(PdfName.RESOURCES));
        PdfDictionary xobj = (PdfDictionary)PdfReader.getPdfObject((PdfObject)res.get(PdfName.XOBJECT));
        if (xobj != null) {
            for (PdfName name : xobj.getKeys()) {
                PdfDictionary tg;
                PdfName subtype;
                PdfObject obj = xobj.get(name);
                if (!obj.isIndirect() || !PdfName.IMAGE.equals((Object)(subtype = (PdfName)PdfReader.getPdfObject((PdfObject)(tg = (PdfDictionary)PdfReader.getPdfObject((PdfObject)obj)).get(PdfName.SUBTYPE))))) continue;
                int xrefIdx = ((PRIndirectReference)obj).getNumber();
                PdfObject pdfObj = doc.getPdfObject(xrefIdx);
                PdfStream str = (PdfStream)pdfObj;
                byte[] bytes = PdfReader.getStreamBytesRaw((PRStream)((PRStream)str));
                String filter = tg.get(PdfName.FILTER).toString();
                String width = tg.get(PdfName.WIDTH).toString();
                String height = tg.get(PdfName.HEIGHT).toString();
                String bpp = tg.get(PdfName.BITSPERCOMPONENT).toString();
                if ("/FlateDecode".equals(filter)) {
                    bytes = PdfReader.FlateDecode((byte[])bytes, (boolean)true);
                    try {
                        images.add(Image.getInstance((byte[])bytes));
                    }
                    catch (BadElementException ex) {
                        log.warn("problem to process FlatDecoded Image", (Throwable)ex);
                    }
                    continue;
                }
                if (!PdfName.FORM.equals((Object)subtype) && !PdfName.GROUP.equals((Object)subtype)) continue;
                images.addAll(this.GetImagesFromPdfDict(tg, doc));
            }
        }
        return images;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractImagesUsingPdfParser(InputStream is, String prefix, String password, Set<Integer> pagesToProcess, Boolean binarize) throws PdfRecompressionException {
        if (binarize == null) {
            binarize = false;
        }
        log.debug("Extracting images (binarize set to {})", (Object)binarize);
        InputStream inputStream = null;
        if (password != null) {
            try {
                ByteArrayOutputStream decryptedOutputStream = null;
                PdfReader reader = new PdfReader(is, password.getBytes());
                PdfStamper stamper = new PdfStamper(reader, decryptedOutputStream);
                stamper.close();
                inputStream = new ByteArrayInputStream(decryptedOutputStream.toByteArray());
            }
            catch (DocumentException ex) {
                throw new PdfRecompressionException(ex);
            }
            catch (IOException ex) {
                throw new PdfRecompressionException("Reading file caused exception", ex);
            }
        } else {
            inputStream = is;
        }
        PDFParser parser = null;
        COSDocument doc = null;
        try {
            parser = new PDFParser(inputStream);
            parser.parse();
            doc = parser.getDocument();
            List objs = doc.getObjectsByType(COSName.XOBJECT);
            if (objs != null) {
                for (COSObject obj : objs) {
                    String key;
                    COSBase subtype = obj.getItem(COSName.SUBTYPE);
                    if (!subtype.toString().equalsIgnoreCase("COSName{Image}")) continue;
                    COSBase imageObj = obj.getObject();
                    COSBase cosNameObj = obj.getItem(COSName.NAME);
                    if (cosNameObj != null) {
                        String cosNameKey = cosNameObj.toString();
                        int startOfKey = cosNameKey.indexOf("{") + 1;
                        key = cosNameKey.substring(startOfKey, cosNameKey.length() - 1);
                    } else {
                        key = "im0";
                    }
                    int objectNum = obj.getObjectNumber().intValue();
                    int genNum = obj.getGenerationNumber().intValue();
                    PDXObjectImage image = (PDXObjectImage)PDXObjectImage.createXObject((COSBase)imageObj);
                    PDStream pdStr = new PDStream(image.getCOSStream());
                    List filters = pdStr.getFilters();
                    log.debug("Detected image with color depth: {} bits", (Object)image.getBitsPerComponent());
                    if (filters == null) continue;
                    log.debug("Detected filters: {}", (Object)filters.toString());
                    if (image.getBitsPerComponent() > 1 && !binarize.booleanValue()) {
                        log.info("It is not a bitonal image => skipping");
                        continue;
                    }
                    if (filters.contains(COSName.LZW_DECODE.getName())) {
                        log.info("This is LZWDecoded => skipping");
                        continue;
                    }
                    if (filters.contains(COSName.FLATE_DECODE.getName())) {
                        log.debug("FlateDecoded image detected");
                    }
                    if (filters.contains("JBIG2Decode")) {
                        log.warn("Allready compressed according to JBIG2 standard => skipping");
                        continue;
                    }
                    if (filters.contains("JPXDecode")) {
                        log.warn("Unsupported filter JPXDecode => skipping");
                        continue;
                    }
                    String name = this.getUniqueFileName(prefix, image.getSuffix());
                    log.info("Writing image: {}", (Object)name);
                    image.write2file(name);
                    PdfImageInformation pdfImageInfo = new PdfImageInformation(key, image.getWidth(), image.getHeight(), objectNum, genNum);
                    this.originalImageInformations.add(pdfImageInfo);
                    this.namesOfImages.add(name + "." + image.getSuffix());
                }
            }
        }
        catch (IOException ex) {
            Tools.deleteFilesFromList(this.namesOfImages);
            throw new PdfRecompressionException("Unable to parse PDF document", ex);
        }
        catch (Exception ex) {
            Tools.deleteFilesFromList(this.namesOfImages);
        }
        finally {
            if (doc != null) {
                try {
                    doc.close();
                }
                catch (IOException ex) {
                    throw new PdfRecompressionException(ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractImagesUsingPdfObjectAccess(String pdfFile, String prefix, String password, Set<Integer> pagesToProcess, Boolean binarize) throws PdfRecompressionException {
        if (binarize == null) {
            binarize = false;
        }
        if (pdfFile == null) {
            throw new IllegalArgumentException(pdfFile);
        }
        InputStream inputStream = null;
        if (password != null) {
            try {
                log.debug("PDF probably encrypted, trying to decrypt using given password {}", (Object)password);
                ByteArrayOutputStream decryptedOutputStream = null;
                PdfReader reader = new PdfReader(pdfFile, password.getBytes());
                PdfStamper stamper = new PdfStamper(reader, decryptedOutputStream);
                stamper.close();
                inputStream = new ByteArrayInputStream(decryptedOutputStream.toByteArray());
            }
            catch (DocumentException ex) {
                throw new PdfRecompressionException(ex);
            }
            catch (IOException ex) {
                throw new PdfRecompressionException("Reading file caused exception", ex);
            }
        }
        try {
            inputStream = new FileInputStream(pdfFile);
        }
        catch (FileNotFoundException ex) {
            throw new PdfRecompressionException("File wasn't found", ex);
        }
        if (prefix == null && pdfFile.length() > 4) {
            prefix = pdfFile.substring(0, pdfFile.length() - 4);
        }
        PDFParser parser = null;
        PDDocument doc = null;
        try {
            parser = new PDFParser(inputStream);
            parser.parse();
            doc = parser.getPDDocument();
            AccessPermission accessPermissions = doc.getCurrentAccessPermission();
            if (!accessPermissions.canExtractContent()) {
                throw new PdfRecompressionException("Error: You do not have permission to extract images.");
            }
            List pages = doc.getDocumentCatalog().getAllPages();
            for (int pageNumber = 0; pageNumber < pages.size(); ++pageNumber) {
                PDPage page;
                PDResources resources;
                Map xobjs;
                if (pagesToProcess != null && !pagesToProcess.contains(pageNumber + 1) || (xobjs = (resources = (page = (PDPage)pages.get(pageNumber)).getResources()).getXObjects()) == null) continue;
                for (String key : xobjs.keySet()) {
                    Map images;
                    PDXObject xobj = (PDXObject)xobjs.get(key);
                    if (xobj instanceof PDXObjectForm) {
                        PDXObjectForm xform = (PDXObjectForm)xobj;
                        images = xform.getResources().getImages();
                    } else {
                        images = resources.getImages();
                    }
                    if (images == null) continue;
                    for (String imKey : images.keySet()) {
                        PDXObjectImage image = (PDXObjectImage)images.get(imKey);
                        PDStream pdStr = new PDStream(image.getCOSStream());
                        List filters = pdStr.getFilters();
                        if (image.getBitsPerComponent() > 1 && !binarize.booleanValue()) {
                            log.info("It is not a bitonal image => skipping");
                            continue;
                        }
                        if (filters.contains(COSName.LZW_DECODE.getName())) {
                            log.info("This is LZWDecoded => skipping");
                            continue;
                        }
                        if (filters.contains("JBIG2Decode")) {
                            log.info("Allready compressed according to JBIG2 standard => skipping");
                            continue;
                        }
                        if (filters.contains("JPXDecode")) {
                            log.info("Unsupported filter JPXDecode => skipping");
                            continue;
                        }
                        COSObject cosObj = new COSObject(image.getCOSObject());
                        int objectNum = cosObj.getObjectNumber().intValue();
                        int genNum = cosObj.getGenerationNumber().intValue();
                        log.debug(objectNum + " " + genNum + " obj");
                        String name = this.getUniqueFileName(prefix + imKey, image.getSuffix());
                        log.debug("Writing image:" + name);
                        image.write2file(name);
                        PdfImageInformation pdfImageInfo = new PdfImageInformation(key, image.getWidth(), image.getHeight(), objectNum, genNum);
                        this.originalImageInformations.add(pdfImageInfo);
                        log.debug(pdfImageInfo.toString());
                        this.namesOfImages.add(name + "." + image.getSuffix());
                    }
                }
            }
        }
        catch (IOException ex) {
            Tools.deleteFilesFromList(this.namesOfImages);
            throw new PdfRecompressionException("Unable to parse PDF document", ex);
        }
        catch (Exception ex) {
            Tools.deleteFilesFromList(this.namesOfImages);
        }
        finally {
            if (doc != null) {
                try {
                    doc.close();
                }
                catch (IOException ex) {
                    throw new PdfRecompressionException(ex);
                }
            }
        }
    }

    public String getUniqueFileName(String prefix, String suffix) {
        String uniqueName = null;
        File f = null;
        while (f == null || f.exists()) {
            uniqueName = prefix + "-" + this.imageCounter;
            f = new File(uniqueName + "." + suffix);
            ++this.imageCounter;
        }
        return uniqueName;
    }
}

