/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.pdfjbim;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfWriter;
import cz.muni.pdfjbim.Jbig2ForPdf;
import cz.muni.pdfjbim.PdfImage;
import cz.muni.pdfjbim.PdfImageInformation;
import cz.muni.pdfjbim.PdfObjId;
import cz.muni.pdfjbim.PdfRecompressionException;
import cz.muni.pdfjbim.Tools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectForm;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfImageProcessor {
    private int imageCounter = 1;
    private List<String> namesOfImages = new ArrayList<String>();
    private List<PdfImageInformation> originalImageInformations = new ArrayList<PdfImageInformation>();
    private static final Logger log = LoggerFactory.getLogger(PdfImageProcessor.class);

    public List<String> getNamesOfImages() {
        return this.namesOfImages;
    }

    public List<PdfImageInformation> getOriginalImageInformations() {
        return this.originalImageInformations;
    }

    public void extractImages(File pdfFile, String password, Set<Integer> pagesToProcess, Boolean binarize) throws PdfRecompressionException {
        if (binarize == null) {
            binarize = false;
        }
        if (pdfFile == null) {
            throw new IllegalArgumentException("pdfFile");
        }
        String prefix = null;
        if (prefix == null && pdfFile.length() > 4L) {
            String fileName = pdfFile.getName();
            prefix = fileName.substring(0, fileName.length() - 4);
        }
        try {
            FileInputStream is = new FileInputStream(pdfFile);
            this.extractImagesUsingPdfParser(is, prefix, password, pagesToProcess, binarize);
        }
        catch (FileNotFoundException ex) {
            throw new PdfRecompressionException("File doesn't exist", ex);
        }
    }

    public void extractImages(String pdfFile, String password, Set<Integer> pagesToProcess, Boolean binarize) throws PdfRecompressionException {
        if (binarize == null) {
            binarize = false;
        }
        if (pdfFile == null) {
            throw new IllegalArgumentException(pdfFile);
        }
        String prefix = null;
        if (prefix == null && pdfFile.length() > 4) {
            prefix = pdfFile.substring(0, pdfFile.length() - 4);
        }
        try {
            FileInputStream is = new FileInputStream(pdfFile);
            this.extractImagesUsingPdfParser(is, prefix, password, pagesToProcess, binarize);
        }
        catch (FileNotFoundException ex) {
            throw new PdfRecompressionException("File doesn't exist", ex);
        }
    }

    public void extractImages(InputStream is, String password, Set<Integer> pagesToProcess, Boolean binarize) throws PdfRecompressionException {
        if (binarize == null) {
            binarize = false;
        }
        String prefix = PdfImageProcessor.class.getName();
        this.extractImagesUsingPdfParser(is, prefix, password, pagesToProcess, binarize);
    }

    public void extractImagesUsingPdfParser(InputStream is, String prefix, String password, Set<Integer> pagesToProcess, Boolean binarize) throws PdfRecompressionException {
        if (binarize == null) {
            binarize = false;
        }
        InputStream inputStream = null;
        if (password != null) {
            try {
                ByteArrayOutputStream decryptedOutputStream = null;
                PdfReader reader = new PdfReader(is, password.getBytes());
                PdfStamper stamper = new PdfStamper(reader, decryptedOutputStream);
                stamper.close();
                inputStream = new ByteArrayInputStream(decryptedOutputStream.toByteArray());
            }
            catch (DocumentException ex) {
                throw new PdfRecompressionException(ex);
            }
            catch (IOException ex) {
                throw new PdfRecompressionException("Reading file caused exception", ex);
            }
        } else {
            inputStream = is;
        }
        PDFParser parser = null;
        COSDocument doc = null;
        try {
            parser = new PDFParser(inputStream);
            parser.parse();
            doc = parser.getDocument();
            List objs = doc.getObjectsByType(COSName.XOBJECT);
            if (objs != null) {
                for (COSObject obj : objs) {
                    String key;
                    COSBase subtype = obj.getItem(COSName.SUBTYPE);
                    if (!subtype.toString().equalsIgnoreCase("COSName{Image}")) continue;
                    COSBase imageObj = obj.getObject();
                    COSBase cosNameObj = obj.getItem(COSName.NAME);
                    if (cosNameObj != null) {
                        String cosNameKey = cosNameObj.toString();
                        int startOfKey = cosNameKey.indexOf("{") + 1;
                        key = cosNameKey.substring(startOfKey, cosNameKey.length() - 1);
                    } else {
                        key = "im0";
                    }
                    int objectNum = obj.getObjectNumber().intValue();
                    int genNum = obj.getGenerationNumber().intValue();
                    PDXObjectImage image = (PDXObjectImage)PDXObjectImage.createXObject((COSBase)imageObj);
                    PDStream pdStr = new PDStream(image.getCOSStream());
                    List filters = pdStr.getFilters();
                    if (image.getBitsPerComponent() > 1 && !binarize.booleanValue()) {
                        log.info("It is not a bitonal image => skipping");
                        continue;
                    }
                    if (filters.contains(COSName.LZW_DECODE.getName())) {
                        log.info("This is LZWDecoded => skipping");
                        continue;
                    }
                    if (filters.contains("JBIG2Decode")) {
                        log.warn("Allready compressed according to JBIG2 standard => skipping");
                        continue;
                    }
                    if (filters.contains("JPXDecode")) {
                        log.warn("Unsupported filter JPXDecode => skipping");
                        continue;
                    }
                    String name = this.getUniqueFileName(prefix, image.getSuffix());
                    log.info("Writing image:" + name);
                    image.write2file(name);
                    PdfImageInformation pdfImageInfo = new PdfImageInformation(key, image.getWidth(), image.getHeight(), objectNum, genNum);
                    this.originalImageInformations.add(pdfImageInfo);
                    this.namesOfImages.add(name + "." + image.getSuffix());
                }
            }
        }
        catch (IOException ex) {
            throw new PdfRecompressionException("Unable to parse PDF document", ex);
        }
        finally {
            if (doc != null) {
                try {
                    doc.close();
                }
                catch (IOException ex) {
                    throw new PdfRecompressionException(ex);
                }
            }
        }
    }

    public void extractImagesUsingPdfObjectAccess(String pdfFile, String password, Set<Integer> pagesToProcess, Boolean silent, Boolean binarize) throws PdfRecompressionException {
        if (binarize == null) {
            binarize = false;
        }
        if (pdfFile == null) {
            throw new IllegalArgumentException(pdfFile);
        }
        String prefix = null;
        InputStream inputStream = null;
        if (password != null) {
            try {
                ByteArrayOutputStream decryptedOutputStream = null;
                PdfReader reader = new PdfReader(pdfFile, password.getBytes());
                PdfStamper stamper = new PdfStamper(reader, decryptedOutputStream);
                stamper.close();
                inputStream = new ByteArrayInputStream(decryptedOutputStream.toByteArray());
            }
            catch (DocumentException ex) {
                throw new PdfRecompressionException(ex);
            }
            catch (IOException ex) {
                throw new PdfRecompressionException("Reading file caused exception", ex);
            }
        }
        try {
            inputStream = new FileInputStream(pdfFile);
        }
        catch (FileNotFoundException ex) {
            throw new PdfRecompressionException("File wasn't found", ex);
        }
        if (prefix == null && pdfFile.length() > 4) {
            prefix = pdfFile.substring(0, pdfFile.length() - 4);
        }
        PDFParser parser = null;
        PDDocument doc = null;
        try {
            parser = new PDFParser(inputStream);
            parser.parse();
            doc = parser.getPDDocument();
            AccessPermission accessPermissions = doc.getCurrentAccessPermission();
            if (!accessPermissions.canExtractContent()) {
                throw new PdfRecompressionException("Error: You do not have permission to extract images.");
            }
            List pages = doc.getDocumentCatalog().getAllPages();
            for (int pageNumber = 0; pageNumber < pages.size(); ++pageNumber) {
                PDPage page;
                PDResources resources;
                Map xobjs;
                if (pagesToProcess != null && !pagesToProcess.contains(pageNumber + 1) || (xobjs = (resources = (page = (PDPage)pages.get(pageNumber)).getResources()).getXObjects()) == null) continue;
                for (String key : xobjs.keySet()) {
                    Map images;
                    PDXObject xobj = (PDXObject)xobjs.get(key);
                    if (xobj instanceof PDXObjectForm) {
                        PDXObjectForm xform = (PDXObjectForm)xobj;
                        images = xform.getResources().getImages();
                    } else {
                        images = resources.getImages();
                    }
                    if (images == null) continue;
                    for (String imKey : images.keySet()) {
                        PDXObjectImage image = (PDXObjectImage)images.get(imKey);
                        PDStream pdStr = new PDStream(image.getCOSStream());
                        List filters = pdStr.getFilters();
                        if (image.getBitsPerComponent() > 1) {
                            log.info("It is not a bitonal image => skipping");
                            continue;
                        }
                        if (filters.contains(COSName.LZW_DECODE.getName())) {
                            log.info("This is LZWDecoded => skipping");
                            continue;
                        }
                        if (filters.contains("JBIG2Decode")) {
                            log.info("Allready compressed according to JBIG2 standard => skipping");
                            continue;
                        }
                        if (filters.contains("JPXDecode")) {
                            log.info("Unsupported filter JPXDecode => skipping");
                            continue;
                        }
                        COSObject cosObj = new COSObject(image.getCOSObject());
                        int objectNum = cosObj.getObjectNumber().intValue();
                        int genNum = cosObj.getGenerationNumber().intValue();
                        log.debug(objectNum + " " + genNum + " obj");
                        String name = this.getUniqueFileName(prefix + imKey, image.getSuffix());
                        log.debug("Writing image:" + name);
                        image.write2file(name);
                        PdfImageInformation pdfImageInfo = new PdfImageInformation(key, image.getWidth(), image.getHeight(), objectNum, genNum);
                        this.originalImageInformations.add(pdfImageInfo);
                        log.debug(pdfImageInfo.toString());
                        this.namesOfImages.add(name + "." + image.getSuffix());
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new PdfRecompressionException("Unable to parse PDF document", ex);
        }
        finally {
            if (doc != null) {
                try {
                    doc.close();
                }
                catch (IOException ex) {
                    throw new PdfRecompressionException(ex);
                }
            }
        }
    }

    public String getUniqueFileName(String prefix, String suffix) {
        String uniqueName = null;
        File f = null;
        while (f == null || f.exists()) {
            uniqueName = prefix + "-" + this.imageCounter;
            f = new File(uniqueName + "." + suffix);
            ++this.imageCounter;
        }
        return uniqueName;
    }

    public void replaceImageUsingIText(String pdfName, OutputStream os, Jbig2ForPdf imagesData) throws PdfRecompressionException {
        if (pdfName == null) {
            throw new NullPointerException("pdfName");
        }
        if (os == null) {
            throw new NullPointerException("os");
        }
        if (imagesData == null) {
            throw new NullPointerException("imagesData is null => nothing to recompress");
        }
        Map<PdfObjId, PdfImage> jbig2Images = imagesData.getMapOfJbig2Images();
        PdfStamper stp = null;
        try {
            String key;
            Iterator<PdfImage> itImages;
            PdfReader pdf = new PdfReader(pdfName);
            stp = new PdfStamper(pdf, os);
            PdfWriter writer = stp.getWriter();
            int version = Integer.parseInt(String.valueOf(pdf.getPdfVersion()));
            if (version < 4) {
                writer.setPdfVersion(PdfWriter.PDF_VERSION_1_4);
            }
            if ((itImages = jbig2Images.values().iterator()).hasNext()) {
                PdfImage myImg = itImages.next();
                key = myImg.getPdfImageInformation().getKey();
            } else {
                key = "im0";
            }
            for (int pageNum = 1; pageNum <= pdf.getNumberOfPages(); ++pageNum) {
                PRIndirectReference ref;
                PdfObjId imId;
                PdfImage jbImage;
                PdfName type;
                PdfDictionary tg;
                PdfDictionary pg = pdf.getPageN(pageNum);
                PdfDictionary resPg = (PdfDictionary)PdfReader.getPdfObject((PdfObject)pg.get(PdfName.RESOURCES));
                PdfDictionary xobjResPg = (PdfDictionary)PdfReader.getPdfObject((PdfObject)resPg.get(PdfName.XOBJECT));
                PdfObject obj = null;
                if (xobjResPg != null) {
                    Iterator it = xobjResPg.getKeys().iterator();
                    while (it.hasNext()) {
                        PdfObject pdfObjIndirect = xobjResPg.get((PdfName)it.next());
                        if (!pdfObjIndirect.isIndirect()) continue;
                        PdfDictionary pdfObj2 = (PdfDictionary)PdfReader.getPdfObject((PdfObject)pdfObjIndirect);
                        PdfDictionary xobj2Res = (PdfDictionary)PdfReader.getPdfObject((PdfObject)pdfObj2.get(PdfName.RESOURCES));
                        if (xobj2Res != null) {
                            Iterator it2 = xobj2Res.getKeys().iterator();
                            while (it2.hasNext()) {
                                PdfObject resObj = xobj2Res.get((PdfName)it2.next());
                            }
                            PdfDictionary xobj = (PdfDictionary)PdfReader.getPdfObject((PdfObject)xobj2Res.get(PdfName.XOBJECT));
                            if (xobj == null) continue;
                            obj = xobj.get(new PdfName(key));
                            continue;
                        }
                        obj = xobjResPg.get(new PdfName(key));
                        if (obj != null) continue;
                        obj = pdfObjIndirect;
                    }
                }
                if (obj == null || !obj.isIndirect() || (tg = (PdfDictionary)PdfReader.getPdfObject(obj)) == null || !PdfName.IMAGE.equals((Object)(type = (PdfName)PdfReader.getPdfObject((PdfObject)tg.get(PdfName.SUBTYPE)))) || (jbImage = jbig2Images.get(imId = new PdfObjId((ref = (PRIndirectReference)obj).getNumber(), ref.getGeneration()))) == null) continue;
                PdfImageInformation jbImageInfo = jbImage.getPdfImageInformation();
                Image img = Image.getInstance((int)jbImageInfo.getWidth(), (int)jbImageInfo.getHeight(), (byte[])jbImage.getImageData(), (byte[])imagesData.getGlobalData());
                PdfReader.killIndirect((PdfObject)obj);
                Image maskImage = img.getImageMask();
                if (maskImage != null) {
                    writer.addDirectImageSimple(maskImage);
                }
                writer.addDirectImageSimple(img, (PdfIndirectReference)((PRIndirectReference)obj));
            }
            stp.close();
        }
        catch (IOException ioEx) {
            throw new PdfRecompressionException(ioEx);
        }
        catch (DocumentException dEx) {
            throw new PdfRecompressionException(dEx);
        }
        finally {
            Tools.deleteFilesFromList(imagesData.getJbFiles().toArray(new File[0]));
        }
    }
}

