/*
 * Decompiled with CFR 0.152.
 */
package cz.muni.pdfjbim;

import cz.muni.pdfjbim.Jbig2FilenameFilter;
import cz.muni.pdfjbim.PdfImage;
import cz.muni.pdfjbim.PdfImageInformation;
import cz.muni.pdfjbim.PdfObjId;
import cz.muni.pdfjbim.PdfRecompressionException;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jbig2ForPdf {
    private byte[] globalData;
    private SortedMap<Integer, PdfImage> jbig2Images;
    private List<File> jbFileNames = new ArrayList<File>();
    private static final Logger log = LoggerFactory.getLogger(Jbig2ForPdf.class);

    public Jbig2ForPdf(String pathToDir, String basename) throws PdfRecompressionException {
        this.jbig2Images = new TreeMap<Integer, PdfImage>();
        File directory = new File(pathToDir);
        if (!directory.isDirectory()) {
            throw new PdfRecompressionException("argument pathToDir doesn`t contain path to directory");
        }
        Jbig2FilenameFilter jbig2fileNameFilter = new Jbig2FilenameFilter(basename);
        File[] fileNames = directory.listFiles(jbig2fileNameFilter);
        for (int i = 0; i < fileNames.length; ++i) {
            File checkFile = fileNames[i];
            String fileName = checkFile.getName();
            log.trace("Checking file {} if it is an adequate JBIG2 file", (Object)checkFile.getPath());
            if (checkFile.isDirectory()) {
                log.trace("{} is a dictionary, continuing with next file");
                continue;
            }
            int filenameLengthWithoutSuffix = fileName.lastIndexOf(".");
            if (filenameLengthWithoutSuffix + 1 == fileName.length() - 4 && fileName.substring(0, filenameLengthWithoutSuffix).equals(basename)) {
                String suffix = fileName.substring(fileName.length() - 4);
                try {
                    int suffixInt = Integer.parseInt(suffix);
                    log.debug("Recognized jbig2 image file: {}", (Object)checkFile);
                    this.jbFileNames.add(checkFile);
                    this.jbig2Images.put(suffixInt, new PdfImage(checkFile));
                }
                catch (NumberFormatException ex) {
                    log.warn("NumberFormatException encountered while checking suffix", (Throwable)ex);
                    continue;
                }
            }
            if (!fileName.equals(basename + ".sym")) continue;
            Long sizeOfFile = checkFile.length();
            log.debug("Recognized global dictionary: {}", (Object)checkFile);
            int imageSize = 0;
            FileInputStream jbImageInput = null;
            try {
                jbImageInput = new FileInputStream(checkFile);
                this.jbFileNames.add(checkFile);
                if (sizeOfFile > Integer.MAX_VALUE) {
                    throw new PdfRecompressionException("Cannot process image greater than 2147483647");
                }
                DataInputStream inputData = new DataInputStream(jbImageInput);
                imageSize = sizeOfFile.intValue();
                byte[] imageBytes = new byte[imageSize];
                inputData.readFully(imageBytes);
                this.globalData = imageBytes;
                continue;
            }
            catch (FileNotFoundException ex) {
                throw new PdfRecompressionException(ex);
            }
            catch (IOException ioEx) {
                throw new PdfRecompressionException("io error", ioEx);
            }
        }
    }

    public void addJbig2Image(int key, PdfImage jbImage) {
        this.jbig2Images.put(key, jbImage);
    }

    public void setJbig2ImageInfo(int i, PdfImageInformation pdfImageInformation) {
        ((PdfImage)this.jbig2Images.get(i)).setPdfImageInformation(pdfImageInformation);
    }

    public void setJbig2ImagesInfo(List<PdfImageInformation> pdfImageInformations) throws PdfRecompressionException {
        if (pdfImageInformations == null) {
            throw new NullPointerException("pdfImageInformations");
        }
        log.debug("Number of informations: {} vs number of images: {}", pdfImageInformations, this.jbig2Images);
        if (pdfImageInformations.size() != this.jbig2Images.size()) {
            throw new PdfRecompressionException("There can't be difference in count of images and their informations");
        }
        for (int i = 0; i < this.jbig2Images.size(); ++i) {
            this.setJbig2ImageInfo(i, pdfImageInformations.get(i));
        }
    }

    public void setGlobalData(byte[] globalData) {
        this.globalData = globalData;
    }

    public void setJbig2Images(SortedMap<Integer, PdfImage> jbig2Images) {
        this.jbig2Images = jbig2Images;
    }

    public byte[] getGlobalData() {
        return this.globalData;
    }

    public PdfImage getJbig2Image(int index) {
        return (PdfImage)this.jbig2Images.get(index);
    }

    public SortedMap<Integer, PdfImage> getSortedMapOfJbig2Images() {
        return this.jbig2Images;
    }

    public Map<PdfObjId, PdfImage> getMapOfJbig2Images() {
        HashMap<PdfObjId, PdfImage> pdfImages = new HashMap<PdfObjId, PdfImage>();
        log.debug("Returning Jbig2 images associated with their PDF object ID");
        if (!this.jbig2Images.isEmpty()) {
            for (int i = 0; i <= this.jbig2Images.lastKey(); ++i) {
                PdfImage jb2Im = (PdfImage)this.jbig2Images.get(i);
                PdfImageInformation jb2ImInfo = jb2Im.getPdfImageInformation();
                PdfObjId objId = new PdfObjId(jb2ImInfo.getObjectNum(), jb2ImInfo.getObjectGenNum());
                pdfImages.put(objId, jb2Im);
            }
        }
        return pdfImages;
    }

    public List<File> getJbFiles() {
        return this.jbFileNames;
    }
}

