/*
 * Decompiled with CFR 0.152.
 */
package cz.quanti.mailq.resources.v2;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import cz.quanti.mailq.Connector;
import cz.quanti.mailq.Pagination;
import cz.quanti.mailq.Request;
import cz.quanti.mailq.entities.v2.EmailAddressEntity;
import cz.quanti.mailq.entities.v2.EmailAddressesEntity;
import cz.quanti.mailq.entities.v2.RecipientsListEntity;
import cz.quanti.mailq.entities.v2.RecipientsListEntriesEntity;
import cz.quanti.mailq.entities.v2.RecipientsListEntryEntity;
import cz.quanti.mailq.entities.v2.RecipientsListsEntity;
import cz.quanti.mailq.entities.v2.UnsubscriberEntity;
import cz.quanti.mailq.entities.v2.UnsubscribersEntity;
import cz.quanti.mailq.exceptions.ApiException;
import cz.quanti.mailq.exceptions.InvalidRequestException;
import cz.quanti.mailq.resources.v2.BaseResource;
import java.util.ArrayList;
import java.util.Set;

@Singleton
public class RecipientsListResource
extends BaseResource {
    @Inject
    private RecipientsListResource(Connector connector) {
        super(connector);
    }

    public RecipientsListsEntity getRecipientsLists(Pagination pagination) throws ApiException, InvalidRequestException {
        Request request = Request.builder("GET", "/recipients-lists").parameter("limit", pagination.getLimit().toString()).parameter("offset", pagination.getOffset().toString()).build();
        return this.getConnector().send(request, RecipientsListsEntity.class);
    }

    public RecipientsListsEntity getRecipientsListsByEmail(String email, Pagination pagination) throws ApiException, InvalidRequestException {
        Request request = Request.builder("GET", "/recipients-lists").parameter("email", email).parameter("limit", pagination.getLimit().toString()).parameter("offset", pagination.getOffset().toString()).build();
        return this.getConnector().send(request, RecipientsListsEntity.class);
    }

    public RecipientsListEntity createRecipientsList(RecipientsListEntity recipientsList) throws ApiException, InvalidRequestException {
        Request request = Request.builder("POST", "/recipients-lists").entity(recipientsList).build();
        return this.getConnector().send(request, RecipientsListEntity.class);
    }

    public RecipientsListEntity getRecipientsList(Long recipientsListId) throws ApiException, InvalidRequestException {
        Request request = Request.builder("GET", "/recipients-lists/" + recipientsListId).build();
        return this.getConnector().send(request, RecipientsListEntity.class);
    }

    public void deleteRecipientsList(Long recipientsListId, Boolean complete) throws ApiException, InvalidRequestException {
        Request request = Request.builder("DELETE", "/recipients-lists/" + recipientsListId).parameter("complete", complete.toString()).build();
        this.getConnector().send(request);
    }

    public void addRecipientsToList(Long recipientsListId, RecipientsListEntriesEntity recipientsListEntries, Boolean validate) throws ApiException, InvalidRequestException {
        Request request = Request.builder("POST", "/recipients-lists/" + recipientsListId + "/recipients").parameter("dont-validate", Boolean.toString(validate == false)).entity(recipientsListEntries).build();
        this.getConnector().send(request);
    }

    public RecipientsListEntriesEntity getRecipientsFromList(Long recipientsListId, Pagination pagination) throws ApiException, InvalidRequestException {
        Request request = Request.builder("GET", "/recipients-lists/" + recipientsListId + "/recipients").parameter("limit", pagination.getLimit().toString()).parameter("offset", pagination.getOffset().toString()).build();
        return this.getConnector().send(request, RecipientsListEntriesEntity.class);
    }

    public void updateRecipientFromList(Long recipientsListId, RecipientsListEntryEntity recipientsListEntry, Boolean validate) throws ApiException, InvalidRequestException {
        String email = recipientsListEntry.getEmail();
        recipientsListEntry.setEmail(null);
        Request request = Request.builder("PUT", "/recipients-lists/" + recipientsListId + "/recipients/" + email).parameter("dont-validate", Boolean.toString(validate == false)).entity(recipientsListEntry).build();
        this.getConnector().send(request);
    }

    public void deleteRecipientFromList(Long recipientsListId, String email) throws ApiException, InvalidRequestException {
        Request request = Request.builder("DELETE", "/recipients-lists/" + recipientsListId + "/recipients/" + email).build();
        this.getConnector().send(request);
    }

    public UnsubscribersEntity getUnsubscribers(Long recipientsListId, Pagination pagination) throws ApiException, InvalidRequestException {
        Request request = Request.builder("GET", "/recipients-lists/" + recipientsListId + "/unsubscribers").parameter("limit", pagination.getLimit().toString()).parameter("offset", pagination.getOffset().toString()).build();
        return this.getConnector().send(request, UnsubscribersEntity.class);
    }

    public UnsubscriberEntity getUnsunscriber(Long recipientsListId, String email) throws ApiException, InvalidRequestException {
        Request request = Request.builder("GET", "/recipients-lists/" + recipientsListId + "/unsubscribers/" + email).build();
        return this.getConnector().send(request, UnsubscriberEntity.class);
    }

    public void unsubscribe(Long recipientsListId, Set<String> emails) throws ApiException, InvalidRequestException {
        ArrayList<EmailAddressEntity> listOfAddresses = new ArrayList<EmailAddressEntity>();
        emails.forEach(email -> listOfAddresses.add(new EmailAddressEntity((String)email)));
        EmailAddressesEntity addresses = new EmailAddressesEntity(listOfAddresses);
        Request request = Request.builder("POST", "/recipients-lists/" + recipientsListId + "/unsubscribers/").entity(addresses).build();
        this.getConnector().send(request);
    }

    public void unsubscribe(Long recipientsListId, String email) throws ApiException, InvalidRequestException {
        Request request = Request.builder("PUT", "/recipients-lists/" + recipientsListId + "/unsubscribers/" + email).build();
        this.getConnector().send(request);
    }

    public void deleteUnsubscriber(Long recipientsListId, String email) throws ApiException, InvalidRequestException {
        Request request = Request.builder("DELETE", "/recipients-lists/" + recipientsListId + "/unsubscribers/" + email).build();
        this.getConnector().send(request);
    }
}

