/*
 * Decompiled with CFR 0.152.
 */
package cz.quanti.mailq.resources.v2;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import cz.quanti.mailq.Connector;
import cz.quanti.mailq.Pagination;
import cz.quanti.mailq.Request;
import cz.quanti.mailq.entities.v2.EmailAddressEntity;
import cz.quanti.mailq.entities.v2.EmailAddressesEntity;
import cz.quanti.mailq.entities.v2.UnsubscribersEntity;
import cz.quanti.mailq.exceptions.ApiException;
import cz.quanti.mailq.exceptions.InvalidRequestException;
import cz.quanti.mailq.resources.v2.BaseResource;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Set;

@Singleton
public class UnsubscriberResource
extends BaseResource {
    @Inject
    private UnsubscriberResource(Connector connector) {
        super(connector);
    }

    public UnsubscribersEntity getUnsubscribers(LocalDateTime from, Pagination pagination) throws ApiException, InvalidRequestException {
        Request request = Request.builder("GET", "/unsubscribers/").parameter("from", from.format(DateTimeFormatter.ISO_DATE_TIME)).parameter("limit", pagination.getLimit().toString()).parameter("offset", pagination.getOffset().toString()).build();
        return this.getConnector().send(request, UnsubscribersEntity.class);
    }

    public UnsubscribersEntity getUnsubscriber(String email) throws ApiException, InvalidRequestException {
        Request request = Request.builder("GET", "/unsubscribers/" + email).build();
        return this.getConnector().send(request, UnsubscribersEntity.class);
    }

    public void unsubscribe(Set<String> emails) throws ApiException, InvalidRequestException {
        ArrayList<EmailAddressEntity> listOfAddresses = new ArrayList<EmailAddressEntity>();
        emails.forEach(email -> listOfAddresses.add(new EmailAddressEntity((String)email)));
        EmailAddressesEntity addresses = new EmailAddressesEntity(listOfAddresses);
        Request request = Request.builder("POST", "/unsubscribers/").entity(addresses).build();
        this.getConnector().send(request);
    }

    public UnsubscribersEntity unsubscribe(String email) throws ApiException, InvalidRequestException {
        Request request = Request.builder("GET", "/unsubscribers/" + email).build();
        return this.getConnector().send(request, UnsubscribersEntity.class);
    }

    public void deleteUnsubscribe(String email) throws ApiException, InvalidRequestException {
        Request request = Request.builder("DELETE", "/unsubscribers/" + email).build();
        this.getConnector().send(request);
    }
}

