/*
 * Decompiled with CFR 0.152.
 */
package cz.quanti.mailq;

import com.google.gson.Gson;
import com.google.inject.Inject;
import cz.quanti.mailq.Request;
import cz.quanti.mailq.Response;
import cz.quanti.mailq.di.annotations.ApiKey;
import cz.quanti.mailq.di.annotations.BaseUrl;
import cz.quanti.mailq.di.annotations.CompanyId;
import cz.quanti.mailq.entities.v2.BaseEntity;
import cz.quanti.mailq.entities.v2.EmptyResponse;
import cz.quanti.mailq.entities.v2.ErrorEntity;
import cz.quanti.mailq.exceptions.ApiException;
import cz.quanti.mailq.exceptions.InvalidRequestException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class Connector {
    static final Logger logger = Logger.getLogger(Connector.class);
    private String baseUrl;
    private String apiKey;
    private Integer companyId;
    private Gson gson;
    private ResponseHandler<Response> responseHandler = new ResponseHandler<Response>(){

        public Response handleResponse(HttpResponse httpResponse) throws ClientProtocolException, IOException {
            int status = httpResponse.getStatusLine().getStatusCode();
            HttpEntity entity = httpResponse.getEntity();
            return new Response(entity != null ? EntityUtils.toString((HttpEntity)entity) : null, status);
        }
    };

    @Inject
    private Connector(@BaseUrl String baseUrl, @CompanyId Integer companyId, @ApiKey String apiKey, Gson gson) {
        this.baseUrl = baseUrl;
        this.companyId = companyId;
        this.apiKey = apiKey;
        this.gson = gson;
    }

    public EmptyResponse send(Request request) throws ApiException, InvalidRequestException {
        return this.send(request, EmptyResponse.class);
    }

    public <T extends BaseEntity> T send(Request request, Class<T> responseType) throws ApiException, InvalidRequestException {
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            URI uri = this.createUrl(request);
            logger.debug((Object)("Sending HTTP " + request.getMethod() + " to " + uri.toString()));
            HttpUriRequest httpRequest = this.createHttpUriRequest(request, uri.toString());
            Response response = (Response)httpclient.execute(httpRequest, this.responseHandler);
            logger.debug((Object)("Response code: " + response.getHttpCode()));
            logger.debug((Object)("Response data: " + response.getContent()));
            if (response.isOk()) {
                if (response.hasContent()) {
                    return (T)((BaseEntity)this.gson.fromJson(response.getContent(), responseType));
                }
                return (T)((BaseEntity)responseType.newInstance());
            }
            ErrorEntity error = (ErrorEntity)this.gson.fromJson(response.getContent(), ErrorEntity.class);
            if (error != null) {
                throw new ApiException(response.getHttpCode(), error.getCode(), error.getMessage());
            }
            throw new ApiException(response.getHttpCode(), response.getContent());
        }
        catch (ApiException | InvalidRequestException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ApiException(-1, ex.getMessage());
        }
    }

    private URI createUrl(Request request) throws InvalidRequestException {
        try {
            URIBuilder builder = new URIBuilder();
            String url = request.isCompanyRelated() ? String.join((CharSequence)"/", this.baseUrl, "companies", this.companyId.toString()) : this.baseUrl;
            URI tempURI = new URL(url).toURI();
            builder.setScheme(tempURI.getScheme()).setHost(tempURI.getHost()).setPort(tempURI.getPort()).setPath(tempURI.getPath() + request.getPath());
            Map<String, String> parameters = request.getParameters();
            for (String queryKey : parameters.keySet()) {
                builder.setParameter(queryKey, parameters.get(queryKey));
            }
            return builder.build();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new InvalidRequestException();
        }
    }

    private HttpUriRequest createHttpUriRequest(Request request, String url) {
        HttpGet httpRequest = null;
        switch (request.getMethod()) {
            case "GET": {
                httpRequest = new HttpGet(url);
                break;
            }
            case "POST": {
                String json;
                HttpPost post = new HttpPost(url);
                if (request.hasEntity()) {
                    json = this.gson.toJson((Object)request.getEntity());
                    logger.debug((Object)("Data: " + json));
                    post.setEntity((HttpEntity)new StringEntity(json, Charset.forName("UTF-8")));
                    post.setHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
                }
                httpRequest = post;
                break;
            }
            case "PUT": {
                String json;
                HttpPut put = new HttpPut(url);
                if (request.hasEntity()) {
                    json = this.gson.toJson((Object)request.getEntity());
                    logger.debug((Object)("Data: " + json));
                    put.setEntity((HttpEntity)new StringEntity(json, Charset.forName("UTF-8")));
                    put.setHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
                }
                httpRequest = put;
                break;
            }
            case "DELETE": {
                httpRequest = new HttpDelete(url);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        for (String headerName : request.getHeaders().keySet()) {
            httpRequest.addHeader(headerName, request.getHeaders().get(headerName));
        }
        httpRequest.setHeader("X-Api-Key", this.apiKey);
        return httpRequest;
    }
}

