/*
 * Decompiled with CFR 0.152.
 */
package cz.quanti.mailq.di;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import cz.quanti.mailq.di.annotations.ApiKey;
import cz.quanti.mailq.di.annotations.BaseUrl;
import cz.quanti.mailq.di.annotations.CompanyId;
import cz.quanti.mailq.entities.v2.CampaignsEntity;
import cz.quanti.mailq.entities.v2.EmailAddressesEntity;
import cz.quanti.mailq.entities.v2.LogMessagesEntity;
import cz.quanti.mailq.entities.v2.NewslettersEntity;
import cz.quanti.mailq.entities.v2.NotificationsDataEntity;
import cz.quanti.mailq.entities.v2.NotificationsEntity;
import cz.quanti.mailq.entities.v2.RecipientsListEntriesEntity;
import cz.quanti.mailq.entities.v2.RecipientsListsEntity;
import cz.quanti.mailq.entities.v2.SenderEmailsEntity;
import cz.quanti.mailq.entities.v2.SmsNewslettersEntity;
import cz.quanti.mailq.entities.v2.SmsNotificationsEntity;
import cz.quanti.mailq.entities.v2.TagsEntity;
import cz.quanti.mailq.entities.v2.UnsubscribersEntity;
import cz.quanti.mailq.entities.v2.UsersEntity;
import cz.quanti.mailq.json.CampaignsEntitySerializer;
import cz.quanti.mailq.json.EmailAddressesEntitySerializer;
import cz.quanti.mailq.json.LocalDateTimeSerializer;
import cz.quanti.mailq.json.LogMessagesEntitySerializer;
import cz.quanti.mailq.json.NewslettersEntitySerializer;
import cz.quanti.mailq.json.NotificationsDataEntitySerializer;
import cz.quanti.mailq.json.NotificationsEntitySerializer;
import cz.quanti.mailq.json.RecipientsListEntriesEntitySerializer;
import cz.quanti.mailq.json.RecipientsListsEntitySerializer;
import cz.quanti.mailq.json.SenderEmailsEntitySerializer;
import cz.quanti.mailq.json.SmsNewslettersEntitySerializer;
import cz.quanti.mailq.json.SmsNotificationsEntitySerializer;
import cz.quanti.mailq.json.TagsEntitySerializer;
import cz.quanti.mailq.json.UnsubscribersEntitySerializer;
import cz.quanti.mailq.json.UsersEntitySerializer;
import java.time.LocalDateTime;

public class DefaultModule
extends AbstractModule {
    private String baseUrl;
    private String apiKey;
    private Integer companyId;

    public DefaultModule(String baseUrl, Integer companyId, String apiKey) {
        this.baseUrl = baseUrl;
        this.companyId = companyId;
        this.apiKey = apiKey;
    }

    protected void configure() {
        this.bind(Integer.class).annotatedWith(CompanyId.class).toInstance((Object)this.companyId);
        this.bind(String.class).annotatedWith(BaseUrl.class).toInstance((Object)this.baseUrl);
        this.bind(String.class).annotatedWith(ApiKey.class).toInstance((Object)this.apiKey);
    }

    @Provides
    Gson provideGson() {
        Gson temporaryGson = new GsonBuilder().registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeSerializer()).create();
        return new GsonBuilder().registerTypeAdapter(CampaignsEntity.class, (Object)new CampaignsEntitySerializer(temporaryGson)).registerTypeAdapter(UnsubscribersEntity.class, (Object)new UnsubscribersEntitySerializer(temporaryGson)).registerTypeAdapter(NewslettersEntity.class, (Object)new NewslettersEntitySerializer(temporaryGson)).registerTypeAdapter(NotificationsEntity.class, (Object)new NotificationsEntitySerializer(temporaryGson)).registerTypeAdapter(NotificationsDataEntity.class, (Object)new NotificationsDataEntitySerializer(temporaryGson)).registerTypeAdapter(SmsNewslettersEntity.class, (Object)new SmsNewslettersEntitySerializer(temporaryGson)).registerTypeAdapter(SmsNotificationsEntity.class, (Object)new SmsNotificationsEntitySerializer(temporaryGson)).registerTypeAdapter(RecipientsListsEntity.class, (Object)new RecipientsListsEntitySerializer(temporaryGson)).registerTypeAdapter(LogMessagesEntity.class, (Object)new LogMessagesEntitySerializer(temporaryGson)).registerTypeAdapter(RecipientsListEntriesEntity.class, (Object)new RecipientsListEntriesEntitySerializer(temporaryGson)).registerTypeAdapter(EmailAddressesEntity.class, (Object)new EmailAddressesEntitySerializer(temporaryGson)).registerTypeAdapter(TagsEntity.class, (Object)new TagsEntitySerializer(temporaryGson)).registerTypeAdapter(SenderEmailsEntity.class, (Object)new SenderEmailsEntitySerializer(temporaryGson)).registerTypeAdapter(UsersEntity.class, (Object)new UsersEntitySerializer(temporaryGson)).registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeSerializer()).create();
    }
}

