/*
 * Decompiled with CFR 0.152.
 */
package cz.quanti.mailq.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public class LocalDateTimeSerializer
implements JsonDeserializer<LocalDateTime>,
JsonSerializer<LocalDateTime> {
    public LocalDateTime deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        String dateTime = jsonElement.getAsString();
        if (Character.isDigit(dateTime.charAt(0))) {
            if (dateTime.contains("+")) {
                return LocalDateTime.parse(jsonElement.getAsString(), DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            }
            return LocalDateTime.parse(jsonElement.getAsString(), DateTimeFormatter.ISO_DATE_TIME);
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss 'CET' yyyy");
        DateTimeFormatter enFormatter = formatter.withLocale(Locale.ENGLISH);
        return LocalDateTime.parse(jsonElement.getAsString(), enFormatter);
    }

    public JsonElement serialize(LocalDateTime localDateTime, Type type, JsonSerializationContext jsonSerializationContext) {
        return new JsonPrimitive(localDateTime.format(DateTimeFormatter.ISO_DATE_TIME));
    }
}

