/*
 * Decompiled with CFR 0.152.
 */
package cz.quanti.mailq.resources.v2;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import cz.quanti.mailq.Connector;
import cz.quanti.mailq.Pagination;
import cz.quanti.mailq.Request;
import cz.quanti.mailq.entities.v2.EmailAddressEntity;
import cz.quanti.mailq.entities.v2.NewsletterEntity;
import cz.quanti.mailq.entities.v2.NewslettersEntity;
import cz.quanti.mailq.entities.v2.PreparationCommandEntity;
import cz.quanti.mailq.entities.v2.PreparedNewsletterEntity;
import cz.quanti.mailq.entities.v2.TagsEntity;
import cz.quanti.mailq.exceptions.ApiException;
import cz.quanti.mailq.exceptions.InvalidRequestException;
import cz.quanti.mailq.resources.v2.BaseResource;

@Singleton
public class NewsletterResource
extends BaseResource {
    @Inject
    private NewsletterResource(Connector connector) {
        super(connector);
    }

    public NewslettersEntity getNewsletters(Pagination pagination) throws ApiException, InvalidRequestException {
        Request request = Request.builder("GET", "/newsletters").parameter("limit", pagination.getLimit().toString()).parameter("offset", pagination.getOffset().toString()).build();
        return this.getConnector().send(request, NewslettersEntity.class);
    }

    public NewsletterEntity createNewsletter(NewsletterEntity newsletter) throws ApiException, InvalidRequestException {
        Request request = Request.builder("POST", "/newsletters").entity(newsletter).build();
        return this.getConnector().send(request, NewsletterEntity.class);
    }

    public TagsEntity getTags() throws InvalidRequestException, ApiException {
        Request request = Request.builder("GET", "/newsletters/tags").build();
        return this.getConnector().send(request, TagsEntity.class);
    }

    public NewsletterEntity getNewsletterByCode(String code) throws ApiException, InvalidRequestException {
        Request request = Request.builder("GET", "/newsletters").parameter("code", code).build();
        return this.getConnector().send(request, NewsletterEntity.class);
    }

    public NewsletterEntity getNewsletter(Long newsletterId) throws ApiException, InvalidRequestException {
        Request request = Request.builder("GET", "/newsletters/" + newsletterId).build();
        return this.getConnector().send(request, NewsletterEntity.class);
    }

    public void updateNewsletter(NewsletterEntity newsletter) throws ApiException, InvalidRequestException {
        Request request = Request.builder("PUT", "/newsletters/" + newsletter.getId()).entity(newsletter).build();
        this.getConnector().send(request);
    }

    public void updatePreparedNewsletter(PreparedNewsletterEntity preparedNewsletter) throws ApiException, InvalidRequestException {
        Request request = Request.builder("PATCH", "/newsletters/" + preparedNewsletter.getId()).entity(preparedNewsletter).build();
        this.getConnector().send(request);
    }

    public void deleteNewsletter(Long newsletterId) throws ApiException, InvalidRequestException {
        Request request = Request.builder("DELETE", "/newsletters/" + newsletterId).build();
        this.getConnector().send(request);
    }

    public void startNewsletter(Long newsletterId) throws ApiException, InvalidRequestException {
        PreparationCommandEntity preparationCommand = new PreparationCommandEntity(true);
        Request request = Request.builder("PUT", "/newsletters/" + newsletterId + "/preparation").entity(preparationCommand).build();
        this.getConnector().send(request);
    }

    public void stopNewsletter(Long newsletterId) throws ApiException, InvalidRequestException {
        PreparationCommandEntity preparationCommand = new PreparationCommandEntity(false);
        Request request = Request.builder("PUT", "/newsletters/" + newsletterId + "/preparation").entity(preparationCommand).build();
        this.getConnector().send(request);
    }

    public void sendTestEmail(Long newsletterId, String email) throws ApiException, InvalidRequestException {
        EmailAddressEntity emailAddress = new EmailAddressEntity(email);
        Request request = Request.builder("POST", "/newsletters/" + newsletterId + "/test-email").entity(emailAddress).build();
        this.getConnector().send(request);
    }
}

