/*
 * Decompiled with CFR 0.152.
 */
package cz.quanti.mailq;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import cz.quanti.mailq.Pagination;
import cz.quanti.mailq.di.DefaultModule;
import cz.quanti.mailq.entities.v2.CampaignEntity;
import cz.quanti.mailq.entities.v2.CampaignsEntity;
import cz.quanti.mailq.entities.v2.CompanyEntity;
import cz.quanti.mailq.entities.v2.LogMessageEntity;
import cz.quanti.mailq.entities.v2.LogMessagesEntity;
import cz.quanti.mailq.entities.v2.NewsletterEntity;
import cz.quanti.mailq.entities.v2.NewslettersEntity;
import cz.quanti.mailq.entities.v2.NotificationDataEntity;
import cz.quanti.mailq.entities.v2.NotificationEntity;
import cz.quanti.mailq.entities.v2.NotificationsDataEntity;
import cz.quanti.mailq.entities.v2.NotificationsEntity;
import cz.quanti.mailq.entities.v2.PreparedNewsletterEntity;
import cz.quanti.mailq.entities.v2.RecipientsListEntity;
import cz.quanti.mailq.entities.v2.RecipientsListEntriesEntity;
import cz.quanti.mailq.entities.v2.RecipientsListEntryEntity;
import cz.quanti.mailq.entities.v2.RecipientsListsEntity;
import cz.quanti.mailq.entities.v2.SenderEmailEntity;
import cz.quanti.mailq.entities.v2.SenderEmailsEntity;
import cz.quanti.mailq.entities.v2.SmsBatchResultEntity;
import cz.quanti.mailq.entities.v2.SmsNewsletterEntity;
import cz.quanti.mailq.entities.v2.SmsNewslettersEntity;
import cz.quanti.mailq.entities.v2.SmsNotificationBatchEntity;
import cz.quanti.mailq.entities.v2.SmsNotificationDataEntity;
import cz.quanti.mailq.entities.v2.SmsNotificationEntity;
import cz.quanti.mailq.entities.v2.SmsNotificationsEntity;
import cz.quanti.mailq.entities.v2.TagsEntity;
import cz.quanti.mailq.entities.v2.UnsubscriberEntity;
import cz.quanti.mailq.entities.v2.UnsubscribersEntity;
import cz.quanti.mailq.entities.v2.UserEntity;
import cz.quanti.mailq.entities.v2.UsersEntity;
import cz.quanti.mailq.exceptions.ApiException;
import cz.quanti.mailq.exceptions.InvalidRequestException;
import cz.quanti.mailq.resources.v2.CampaignResource;
import cz.quanti.mailq.resources.v2.CompanyResource;
import cz.quanti.mailq.resources.v2.LogMessageResource;
import cz.quanti.mailq.resources.v2.NewsletterResource;
import cz.quanti.mailq.resources.v2.NotificationResource;
import cz.quanti.mailq.resources.v2.RecipientsListResource;
import cz.quanti.mailq.resources.v2.SenderEmailResource;
import cz.quanti.mailq.resources.v2.SmsNewsletterResource;
import cz.quanti.mailq.resources.v2.SmsNotificationResource;
import cz.quanti.mailq.resources.v2.UnsubscriberResource;
import cz.quanti.mailq.resources.v2.UserResource;
import cz.quanti.mailq.resources.v2.ValidatorResource;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MailQ {
    private final CampaignResource campaignResource;
    private final CompanyResource companyResource;
    private final UnsubscriberResource unsubscriberResource;
    private final LogMessageResource logMessageResource;
    private final NewsletterResource newsletterResource;
    private final SmsNewsletterResource smsNewsletterResource;
    private final NotificationResource notificationResource;
    private final SmsNotificationResource smsNotificationResource;
    private final RecipientsListResource recipientsListResource;
    private final SenderEmailResource senderEmailResource;
    private final UserResource userResource;
    private final ValidatorResource validatorResource;

    public MailQ(String baseUrl, Integer companyId, String apiKey) {
        Injector injector = Guice.createInjector((Module[])new Module[]{new DefaultModule(baseUrl, companyId, apiKey)});
        this.campaignResource = (CampaignResource)injector.getInstance(CampaignResource.class);
        this.companyResource = (CompanyResource)injector.getInstance(CompanyResource.class);
        this.unsubscriberResource = (UnsubscriberResource)injector.getInstance(UnsubscriberResource.class);
        this.logMessageResource = (LogMessageResource)injector.getInstance(LogMessageResource.class);
        this.newsletterResource = (NewsletterResource)injector.getInstance(NewsletterResource.class);
        this.smsNewsletterResource = (SmsNewsletterResource)injector.getInstance(SmsNewsletterResource.class);
        this.notificationResource = (NotificationResource)injector.getInstance(NotificationResource.class);
        this.smsNotificationResource = (SmsNotificationResource)injector.getInstance(SmsNotificationResource.class);
        this.recipientsListResource = (RecipientsListResource)injector.getInstance(RecipientsListResource.class);
        this.senderEmailResource = (SenderEmailResource)injector.getInstance(SenderEmailResource.class);
        this.userResource = (UserResource)injector.getInstance(UserResource.class);
        this.validatorResource = (ValidatorResource)injector.getInstance(ValidatorResource.class);
    }

    public CampaignsEntity getCampaigns() throws ApiException, InvalidRequestException {
        return this.getCampaigns(Pagination.DEFAULT);
    }

    public CampaignsEntity getCampaigns(Pagination pagination) throws ApiException, InvalidRequestException {
        return this.campaignResource.getCampaigns(pagination);
    }

    public CampaignEntity getCampaign(Long id) throws ApiException, InvalidRequestException {
        return this.campaignResource.getCampaign(id);
    }

    public CompanyEntity getCompany() throws ApiException, InvalidRequestException {
        return this.companyResource.getCompany();
    }

    public String regenerateApiKey() throws ApiException, InvalidRequestException {
        return this.companyResource.regenerateApiKey();
    }

    public void unsubscribe(String ... emails) throws InvalidRequestException, ApiException {
        if (emails.length == 1) {
            this.unsubscriberResource.unsubscribe(emails[0]);
        } else {
            HashSet<String> emailsSet = new HashSet<String>(Arrays.asList(emails));
            this.unsubscriberResource.unsubscribe(emailsSet);
        }
    }

    public void unsubscribe(Set<String> emails) throws InvalidRequestException, ApiException {
        this.unsubscriberResource.unsubscribe(emails);
    }

    public UnsubscribersEntity getUnsubscribers(LocalDateTime from) throws InvalidRequestException, ApiException {
        return this.getUnsubscribers(from, Pagination.DEFAULT);
    }

    public UnsubscribersEntity getUnsubscribers(LocalDateTime from, Pagination pagination) throws InvalidRequestException, ApiException {
        return this.unsubscriberResource.getUnsubscribers(from, pagination);
    }

    public UnsubscribersEntity getUnsubscriber(String email) throws InvalidRequestException, ApiException {
        return this.unsubscriberResource.getUnsubscriber(email);
    }

    public void deleteUnsubscriber(String email) throws InvalidRequestException, ApiException {
        this.unsubscriberResource.deleteUnsubscribe(email);
    }

    public LogMessagesEntity getLogMessages() throws InvalidRequestException, ApiException {
        return this.getLogMessages(Pagination.DEFAULT);
    }

    public LogMessagesEntity getLogMessages(Pagination pagination) throws InvalidRequestException, ApiException {
        return this.logMessageResource.getLogMessages(pagination);
    }

    public LogMessageEntity getLogMessage(Long id) throws InvalidRequestException, ApiException {
        return this.logMessageResource.getLogMessage(id);
    }

    public NewslettersEntity getNewsletters() throws InvalidRequestException, ApiException {
        return this.getNewsletters(Pagination.DEFAULT);
    }

    public NewslettersEntity getNewsletters(Pagination pagination) throws InvalidRequestException, ApiException {
        return this.newsletterResource.getNewsletters(pagination);
    }

    public NewsletterEntity createNewsletter(NewsletterEntity newsletterEntity) throws InvalidRequestException, ApiException {
        return this.newsletterResource.createNewsletter(newsletterEntity);
    }

    public TagsEntity getNewslettersTags() throws InvalidRequestException, ApiException {
        return this.newsletterResource.getTags();
    }

    public NewsletterEntity getNewsletterByCode(String code) throws InvalidRequestException, ApiException {
        return this.newsletterResource.getNewsletterByCode(code);
    }

    public NewsletterEntity getNewsletter(Long newsletterId) throws InvalidRequestException, ApiException {
        return this.newsletterResource.getNewsletter(newsletterId);
    }

    public void updateNewsletter(NewsletterEntity newsletter) throws InvalidRequestException, ApiException {
        this.newsletterResource.updateNewsletter(newsletter);
    }

    public void updatePreparedNewsletter(PreparedNewsletterEntity preparedNewsletter) throws InvalidRequestException, ApiException {
        this.newsletterResource.updatePreparedNewsletter(preparedNewsletter);
    }

    public void deleteNewsletter(Long newsletterId) throws InvalidRequestException, ApiException {
        this.newsletterResource.deleteNewsletter(newsletterId);
    }

    public void startNewsletter(Long newsletterId) throws InvalidRequestException, ApiException {
        this.newsletterResource.startNewsletter(newsletterId);
    }

    public void stopNewsletter(Long newsletterId) throws InvalidRequestException, ApiException {
        this.newsletterResource.stopNewsletter(newsletterId);
    }

    public void sendTestEmail(Long newsletterId, String email) throws ApiException, InvalidRequestException {
        this.newsletterResource.sendTestEmail(newsletterId, email);
    }

    public SmsNewslettersEntity getSmsNewsletters() throws InvalidRequestException, ApiException {
        return this.getSmsNewsletters(Pagination.DEFAULT);
    }

    public SmsNewslettersEntity getSmsNewsletters(Pagination pagination) throws InvalidRequestException, ApiException {
        return this.smsNewsletterResource.getNewsletters(pagination);
    }

    public SmsNewsletterEntity createSmsNewsletter(SmsNewsletterEntity newsletterEntity) throws InvalidRequestException, ApiException {
        return this.smsNewsletterResource.createNewsletter(newsletterEntity);
    }

    public SmsNewsletterEntity getSmsNewsletter(Long newsletterId) throws InvalidRequestException, ApiException {
        return this.smsNewsletterResource.getNewsletter(newsletterId);
    }

    public void updateSmsNewsletter(SmsNewsletterEntity newsletter) throws ApiException, InvalidRequestException {
        this.smsNewsletterResource.updateNewsletter(newsletter);
    }

    public void deleteSmsNewsletter(Long newsletterId) throws ApiException, InvalidRequestException {
        this.smsNewsletterResource.deleteNewsletter(newsletterId);
    }

    public void startSmsNewsletter(Long newsletterId) throws ApiException, InvalidRequestException {
        this.smsNewsletterResource.startNewsletter(newsletterId);
    }

    public void stopSmsNewsletter(Long newsletterId) throws ApiException, InvalidRequestException {
        this.smsNewsletterResource.stopNewsletter(newsletterId);
    }

    public void sendTestSms(Long newsletterId, String number) throws ApiException, InvalidRequestException {
        this.smsNewsletterResource.sendTestSms(newsletterId, number);
    }

    public NotificationsEntity getNotifications() throws ApiException, InvalidRequestException {
        return this.getNotifications(Pagination.DEFAULT);
    }

    public NotificationsEntity getNotifications(Pagination pagination) throws ApiException, InvalidRequestException {
        return this.notificationResource.getNotifications(pagination);
    }

    public NotificationEntity createNotification(NotificationEntity notification) throws ApiException, InvalidRequestException {
        return this.notificationResource.createNotification(notification);
    }

    public NotificationEntity getNotification(Long notificationId) throws ApiException, InvalidRequestException {
        return this.notificationResource.getNotification(notificationId);
    }

    public void updateNotification(NotificationEntity notification) throws ApiException, InvalidRequestException {
        this.notificationResource.updateNotification(notification);
    }

    public void deleteNotification(Long notificationId) throws ApiException, InvalidRequestException {
        this.notificationResource.deleteNotification(notificationId);
    }

    public NotificationDataEntity sendNotificationEmail(Long notificationId, NotificationDataEntity notificationData) throws ApiException, InvalidRequestException {
        return this.notificationResource.sendNotification(notificationId, notificationData);
    }

    public NotificationsDataEntity getNotificationsData(Long notificationId, String email) throws ApiException, InvalidRequestException {
        return this.getNotificationsData(notificationId, email, Pagination.DEFAULT);
    }

    public NotificationsDataEntity getNotificationsData(Long notificationId, String email, Pagination pagination) throws ApiException, InvalidRequestException {
        return this.notificationResource.getNotificationsData(notificationId, email, pagination);
    }

    public NotificationDataEntity getNotificationData(Long notificationId, String notificationDataId) throws ApiException, InvalidRequestException {
        return this.notificationResource.getNotificationData(notificationId, notificationDataId);
    }

    public SmsNotificationEntity createSmsNotification(SmsNotificationEntity notification) throws ApiException, InvalidRequestException {
        return this.smsNotificationResource.createNotification(notification);
    }

    public SmsNotificationsEntity getSmsNotifications(Pagination pagination) throws ApiException, InvalidRequestException {
        return this.smsNotificationResource.getNotifications(pagination);
    }

    public SmsNotificationEntity getSmsNotification(Long notificationId) throws ApiException, InvalidRequestException {
        return this.smsNotificationResource.getNotification(notificationId);
    }

    public void updateSmsNotification(SmsNotificationEntity notification) throws ApiException, InvalidRequestException {
        this.smsNotificationResource.updateNotification(notification);
    }

    public void deleteSmsNotification(Long notificationId) throws ApiException, InvalidRequestException {
        this.smsNotificationResource.deleteNotification(notificationId);
    }

    public SmsNotificationDataEntity sendSmsNotification(Long notificationId, SmsNotificationDataEntity notification) throws ApiException, InvalidRequestException {
        return this.smsNotificationResource.sendSmsNotification(notificationId, notification);
    }

    public SmsBatchResultEntity sendSmsBatchNotification(Long notificationId, SmsNotificationBatchEntity notificationBatch) throws ApiException, InvalidRequestException {
        return this.smsNotificationResource.sendSmsBatchNotification(notificationId, notificationBatch);
    }

    public SmsNotificationDataEntity getSmsNotificationData(Long notificationId, String notificationDataId) throws ApiException, InvalidRequestException {
        return this.smsNotificationResource.getNotificationData(notificationId, notificationDataId);
    }

    public RecipientsListsEntity getRecipientsLists(Pagination pagination) throws ApiException, InvalidRequestException {
        return this.recipientsListResource.getRecipientsLists(pagination);
    }

    public RecipientsListsEntity getRecipientsListsByEmail(String email, Pagination pagination) throws ApiException, InvalidRequestException {
        return this.recipientsListResource.getRecipientsListsByEmail(email, pagination);
    }

    public RecipientsListEntity getRecipientsList(Long recipientsListId) throws ApiException, InvalidRequestException {
        return this.recipientsListResource.getRecipientsList(recipientsListId);
    }

    public RecipientsListEntity createRecipientsList(RecipientsListEntity recipientsList) throws ApiException, InvalidRequestException {
        return this.recipientsListResource.createRecipientsList(recipientsList);
    }

    public void deleteRecipientsList(Long recipientsListId) throws ApiException, InvalidRequestException {
        this.deleteRecipientsList(recipientsListId, false);
    }

    public void deleteRecipientsList(Long recipientsListId, boolean complete) throws ApiException, InvalidRequestException {
        this.recipientsListResource.deleteRecipientsList(recipientsListId, complete);
    }

    public void addRecipientsToList(Long recipientsListId, List<RecipientsListEntryEntity> entries) throws ApiException, InvalidRequestException {
        this.addRecipientsToList(recipientsListId, entries, true);
    }

    public void addRecipientsToList(Long recipientsListId, List<RecipientsListEntryEntity> entries, Boolean validate) throws ApiException, InvalidRequestException {
        RecipientsListEntriesEntity recipientsListEntries = new RecipientsListEntriesEntity(entries);
        this.recipientsListResource.addRecipientsToList(recipientsListId, recipientsListEntries, validate);
    }

    public RecipientsListEntriesEntity getRecipientsFromList(Long recipientsListId) throws ApiException, InvalidRequestException {
        return this.getRecipientsFromList(recipientsListId, Pagination.DEFAULT);
    }

    public RecipientsListEntriesEntity getRecipientsFromList(Long recipientsListId, Pagination pagination) throws ApiException, InvalidRequestException {
        return this.recipientsListResource.getRecipientsFromList(recipientsListId, pagination);
    }

    public void updateRecipientFromList(Long recipientsListId, RecipientsListEntryEntity recipientsListEntry) throws ApiException, InvalidRequestException {
        this.recipientsListResource.updateRecipientFromList(recipientsListId, recipientsListEntry, true);
    }

    public void updateRecipientFromList(Long recipientsListId, RecipientsListEntryEntity recipientsListEntry, Boolean validate) throws ApiException, InvalidRequestException {
        this.recipientsListResource.updateRecipientFromList(recipientsListId, recipientsListEntry, validate);
    }

    public void deleteRecipientFromList(Long recipientsListId, String email) throws ApiException, InvalidRequestException {
        this.recipientsListResource.deleteRecipientFromList(recipientsListId, email);
    }

    public void unsubscribe(Long recipientsListId, Set<String> emails) throws ApiException, InvalidRequestException {
        this.recipientsListResource.unsubscribe(recipientsListId, emails);
    }

    public void unsubscribe(Long recipientsListId, String ... emails) throws InvalidRequestException, ApiException {
        if (emails.length == 1) {
            this.recipientsListResource.unsubscribe(recipientsListId, emails[0]);
        } else {
            HashSet<String> emailsSet = new HashSet<String>(Arrays.asList(emails));
            this.recipientsListResource.unsubscribe(recipientsListId, emailsSet);
        }
    }

    public UnsubscribersEntity getUnsubscribers(Long recipientsListId) throws InvalidRequestException, ApiException {
        return this.recipientsListResource.getUnsubscribers(recipientsListId, Pagination.DEFAULT);
    }

    public UnsubscribersEntity getUnsubscribers(Long recipientsListId, Pagination pagination) throws InvalidRequestException, ApiException {
        return this.recipientsListResource.getUnsubscribers(recipientsListId, pagination);
    }

    public UnsubscriberEntity getUnsubscriber(Long recipientsListId, String email) throws InvalidRequestException, ApiException {
        return this.recipientsListResource.getUnsunscriber(recipientsListId, email);
    }

    public void deleteUnsubscriber(Long recipientsListId, String email) throws InvalidRequestException, ApiException {
        this.recipientsListResource.deleteUnsubscriber(recipientsListId, email);
    }

    public SenderEmailsEntity getSenderEmails() throws InvalidRequestException, ApiException {
        return this.senderEmailResource.getSenderEmails();
    }

    public SenderEmailEntity getSenderEmail(Long id) throws InvalidRequestException, ApiException {
        return this.senderEmailResource.getSenderEmail(id);
    }

    public UsersEntity getUsers() throws InvalidRequestException, ApiException {
        return this.userResource.getUsers();
    }

    public UserEntity getUser(Long userId) throws InvalidRequestException, ApiException {
        return this.userResource.getUser(userId);
    }

    public void validate(String email) throws InvalidRequestException, ApiException {
        this.validatorResource.validate(email);
    }

    public void validate(String email, int timeout) throws InvalidRequestException, ApiException {
        this.validatorResource.validate(email, timeout);
    }
}

