/*
 * Decompiled with CFR 0.152.
 */
package cz.quanti.mailq.resources.v2;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import cz.quanti.mailq.Connector;
import cz.quanti.mailq.Pagination;
import cz.quanti.mailq.Request;
import cz.quanti.mailq.entities.v2.SmsBatchResultEntity;
import cz.quanti.mailq.entities.v2.SmsNotificationBatchEntity;
import cz.quanti.mailq.entities.v2.SmsNotificationDataEntity;
import cz.quanti.mailq.entities.v2.SmsNotificationEntity;
import cz.quanti.mailq.entities.v2.SmsNotificationsEntity;
import cz.quanti.mailq.exceptions.ApiException;
import cz.quanti.mailq.exceptions.InvalidRequestException;
import cz.quanti.mailq.resources.v2.BaseResource;

@Singleton
public class SmsNotificationResource
extends BaseResource {
    @Inject
    private SmsNotificationResource(Connector connector) {
        super(connector);
    }

    public SmsNotificationsEntity getNotifications(Pagination pagination) throws ApiException, InvalidRequestException {
        Request request = Request.builder("GET", "/sms-notifications").parameter("limit", pagination.getLimit().toString()).parameter("offset", pagination.getOffset().toString()).build();
        return this.getConnector().send(request, SmsNotificationsEntity.class);
    }

    public SmsNotificationEntity createNotification(SmsNotificationEntity notification) throws ApiException, InvalidRequestException {
        Request request = Request.builder("POST", "/sms-notifications").entity(notification).build();
        return this.getConnector().send(request, SmsNotificationEntity.class);
    }

    public SmsNotificationEntity getNotification(Long notificationId) throws ApiException, InvalidRequestException {
        Request request = Request.builder("GET", "/sms-notifications/" + notificationId).build();
        return this.getConnector().send(request, SmsNotificationEntity.class);
    }

    public void updateNotification(SmsNotificationEntity notification) throws ApiException, InvalidRequestException {
        Request request = Request.builder("PUT", "/sms-notifications/" + notification.getId()).entity(notification).build();
        this.getConnector().send(request);
    }

    public void deleteNotification(Long notificationId) throws ApiException, InvalidRequestException {
        Request request = Request.builder("DELETE", "/sms-notifications/" + notificationId).build();
        this.getConnector().send(request);
    }

    public SmsNotificationDataEntity sendSmsNotification(Long notificationId, SmsNotificationDataEntity notification) throws ApiException, InvalidRequestException {
        Request request = Request.builder("POST", "/sms-notifications/" + notificationId + "/data").entity(notification).build();
        return this.getConnector().send(request, SmsNotificationDataEntity.class);
    }

    public SmsBatchResultEntity sendSmsBatchNotification(Long notificationId, SmsNotificationBatchEntity notificationBatch) throws ApiException, InvalidRequestException {
        Request request = Request.builder("POST", "/sms-notifications/" + notificationId + "/data").entity(notificationBatch).build();
        return this.getConnector().send(request, SmsBatchResultEntity.class);
    }

    public SmsNotificationDataEntity getNotificationData(Long notificationId, String notificationDataId) throws ApiException, InvalidRequestException {
        Request request = Request.builder("GET", "/sms-notifications/" + notificationId + "/data/" + notificationDataId).build();
        return this.getConnector().send(request, SmsNotificationDataEntity.class);
    }
}

