package cz.sazel.sqldelight._dont_use.nodesqlite3driver

import app.cash.sqldelight.SuspendingTransacterImpl
import app.cash.sqldelight.db.AfterVersion
import app.cash.sqldelight.db.QueryResult
import app.cash.sqldelight.db.SqlDriver
import app.cash.sqldelight.db.SqlSchema
import cz.sazel.sqldelight._dont_use.TestDatabaseDontUse
import cz.sazel.sqldelight.dontuse.TestDataBaseDontUseQueries
import kotlin.Long
import kotlin.Unit
import kotlin.reflect.KClass

internal val KClass<TestDatabaseDontUse>.schema: SqlSchema<QueryResult.AsyncValue<Unit>>
  get() = TestDatabaseDontUseImpl.Schema

internal fun KClass<TestDatabaseDontUse>.newInstance(driver: SqlDriver): TestDatabaseDontUse =
    TestDatabaseDontUseImpl(driver)

private class TestDatabaseDontUseImpl(
  driver: SqlDriver,
) : SuspendingTransacterImpl(driver), TestDatabaseDontUse {
  override val testDataBaseDontUseQueries: TestDataBaseDontUseQueries =
      TestDataBaseDontUseQueries(driver)

  public object Schema : SqlSchema<QueryResult.AsyncValue<Unit>> {
    override val version: Long
      get() = 1

    override fun create(driver: SqlDriver): QueryResult.AsyncValue<Unit> = QueryResult.AsyncValue {
      driver.execute(null, """
          |CREATE TABLE hockeyPlayer (
          |  player_number INTEGER PRIMARY KEY NOT NULL,
          |  full_name TEXT NOT NULL
          |)
          """.trimMargin(), 0).await()
      driver.execute(null, "CREATE INDEX hockeyPlayer_full_name ON hockeyPlayer(full_name)",
          0).await()
      driver.execute(null, """
          |INSERT INTO hockeyPlayer (player_number, full_name)
          |VALUES (15, 'Ryan Getzlaf')
          """.trimMargin(), 0).await()
    }

    override fun migrate(
      driver: SqlDriver,
      oldVersion: Long,
      newVersion: Long,
      vararg callbacks: AfterVersion,
    ): QueryResult.AsyncValue<Unit> = QueryResult.AsyncValue {
    }
  }
}
