package cz.sazel.sqldelight.dontuse

import app.cash.sqldelight.Query
import app.cash.sqldelight.SuspendingTransacterImpl
import app.cash.sqldelight.db.QueryResult
import app.cash.sqldelight.db.SqlCursor
import app.cash.sqldelight.db.SqlDriver
import kotlin.Any
import kotlin.Long
import kotlin.String

public class TestDataBaseDontUseQueries(
  driver: SqlDriver,
) : SuspendingTransacterImpl(driver) {
  public fun <T : Any> selectAll(mapper: (player_number: Long, full_name: String) -> T): Query<T> =
      Query(1_477_591_335, arrayOf("hockeyPlayer"), driver, "TestDataBaseDontUse.sq", "selectAll",
      """
  |SELECT hockeyPlayer.player_number, hockeyPlayer.full_name
  |FROM hockeyPlayer
  """.trimMargin()) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!
    )
  }

  public fun selectAll(): Query<HockeyPlayer> = selectAll { player_number, full_name ->
    HockeyPlayer(
      player_number,
      full_name
    )
  }

  public fun <T : Any> selectWithLimit(
    `value`: Long,
    value_: Long,
    mapper: (player_number: Long, full_name: String) -> T,
  ): Query<T> = SelectWithLimitQuery(value, value_) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!
    )
  }

  public fun selectWithLimit(value_: Long, value__: Long): Query<HockeyPlayer> =
      selectWithLimit(value_, value__) { player_number, full_name ->
    HockeyPlayer(
      player_number,
      full_name
    )
  }

  public suspend fun insert(player_number: Long?, full_name: String) {
    driver.execute(-854_401_065, """
        |INSERT INTO hockeyPlayer(player_number, full_name)
        |VALUES (?, ?)
        """.trimMargin(), 2) {
          bindLong(0, player_number)
          bindString(1, full_name)
        }.await()
    notifyQueries(-854_401_065) { emit ->
      emit("hockeyPlayer")
    }
  }

  public suspend fun insertFullPlayerObject(hockeyPlayer: HockeyPlayer) {
    driver.execute(-1_156_682_842, """
        |INSERT INTO hockeyPlayer(player_number, full_name)
        |VALUES (?, ?)
        """.trimMargin(), 2) {
          bindLong(0, hockeyPlayer.player_number)
          bindString(1, hockeyPlayer.full_name)
        }.await()
    notifyQueries(-1_156_682_842) { emit ->
      emit("hockeyPlayer")
    }
  }

  public suspend fun updateName(full_name: String, player_number: Long) {
    driver.execute(-78_907_118, """UPDATE hockeyPlayer SET full_name = ? WHERE player_number = ?""",
        2) {
          bindString(0, full_name)
          bindLong(1, player_number)
        }.await()
    notifyQueries(-78_907_118) { emit ->
      emit("hockeyPlayer")
    }
  }

  public suspend fun deletePlayer(player_number: Long) {
    driver.execute(1_726_951_178, """DELETE FROM hockeyPlayer WHERE player_number = ?""", 1) {
          bindLong(0, player_number)
        }.await()
    notifyQueries(1_726_951_178) { emit ->
      emit("hockeyPlayer")
    }
  }

  private inner class SelectWithLimitQuery<out T : Any>(
    public val `value`: Long,
    public val value_: Long,
    mapper: (SqlCursor) -> T,
  ) : Query<T>(mapper) {
    override fun addListener(listener: Query.Listener) {
      driver.addListener("hockeyPlayer", listener = listener)
    }

    override fun removeListener(listener: Query.Listener) {
      driver.removeListener("hockeyPlayer", listener = listener)
    }

    override fun <R> execute(mapper: (SqlCursor) -> QueryResult<R>): QueryResult<R> =
        driver.executeQuery(-369_573_477, """
    |SELECT hockeyPlayer.player_number, hockeyPlayer.full_name
    |FROM hockeyPlayer LIMIT ?,?
    """.trimMargin(), mapper, 2) {
      bindLong(0, value)
      bindLong(1, value_)
    }

    override fun toString(): String = "TestDataBaseDontUse.sq:selectWithLimit"
  }
}
