/*
 * Decompiled with CFR 0.152.
 */
package cz.srayayay.tierion.dataapi;

import cz.srayayay.tierion.common.CredentialsFromPropertiesFile;
import cz.srayayay.tierion.common.Responses;
import cz.srayayay.tierion.dataapi.TierionDataApiClient;
import cz.srayayay.tierion.dataapi.model.DatastoreObject;
import cz.srayayay.tierion.dataapi.model.GetRecordsResponse;
import cz.srayayay.tierion.dataapi.model.RecordObject;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class V1TierionDataApiClient
implements TierionDataApiClient {
    static final String ROOT_TARGET_URL = "https://api.tierion.com/v1";
    private final Client client;
    private final WebTarget rootWebTarget;
    private final WebTarget datastoresWebTarget;
    private final WebTarget recordsWebTarget;

    public V1TierionDataApiClient(String username, String apiKey, Integer connectionPoolSize) {
        this.client = new ResteasyClientBuilder().maxPooledPerRoute(connectionPoolSize.intValue()).connectionPoolSize(connectionPoolSize.intValue()).build().register((Object)new AddAuthenticationHeadersFilter(username, apiKey));
        this.rootWebTarget = this.client.target(ROOT_TARGET_URL);
        this.datastoresWebTarget = this.rootWebTarget.path("/datastores");
        this.recordsWebTarget = this.rootWebTarget.path("/records");
    }

    public V1TierionDataApiClient(String username, String apiKey) {
        this(username, apiKey, 10);
    }

    public V1TierionDataApiClient() {
        this(null, null, 10);
    }

    public V1TierionDataApiClient(Integer connectionPoolSize) {
        this(null, null, connectionPoolSize);
    }

    @Override
    public List<DatastoreObject> getAllDatastores() {
        Response response = (Response)this.datastoresWebTarget.request().get(Response.class);
        return (List)response.readEntity(new GenericType((Type)ParameterizedTypeImpl.make(List.class, new Type[]{DatastoreObject.class}, null)));
    }

    @Override
    public DatastoreObject getDatastore(long id) {
        WebTarget target = this.datastoresWebTarget.path("/" + id);
        Response response = target.request().get();
        Responses.validateResponse(response, Response.Status.OK);
        return (DatastoreObject)response.readEntity(DatastoreObject.class);
    }

    @Override
    public DatastoreObject createDatastore(DatastoreObject datastore) {
        Response response = this.datastoresWebTarget.request().post(Entity.json((Object)datastore));
        if (response.getStatusInfo().equals(Response.Status.INTERNAL_SERVER_ERROR)) {
            return null;
        }
        Responses.validateResponse(response, Response.Status.OK);
        return (DatastoreObject)response.readEntity(DatastoreObject.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteDatastore(long id) {
        WebTarget target = this.datastoresWebTarget.path("/" + id);
        try (Response response = target.request().delete();){
            if (response.getStatusInfo().equals(Response.Status.INTERNAL_SERVER_ERROR)) {
                return;
            }
            Responses.validateResponse(response, Response.Status.OK);
        }
    }

    @Override
    public DatastoreObject updateDatastore(long id, DatastoreObject newDatastore) {
        WebTarget target = this.datastoresWebTarget.path("/" + id);
        Response response = target.request().put(Entity.json((Object)newDatastore));
        Responses.validateResponse(response, Response.Status.OK);
        return (DatastoreObject)response.readEntity(DatastoreObject.class);
    }

    @Override
    public RecordObject getRecord(String id) {
        Response response = this.recordsWebTarget.path("/" + id).request().get();
        Responses.validateResponse(response, Response.Status.OK);
        return (RecordObject)response.readEntity(RecordObject.class);
    }

    @Override
    public GetRecordsResponse getRecords(Long datastoreId, Long page, Long pageSize, Long startDate, Long endDate) {
        WebTarget target = this.recordsWebTarget.queryParam("datastoreId", new Object[]{datastoreId}).queryParam("page", new Object[]{page}).queryParam("pageSize", new Object[]{pageSize}).queryParam("startDate", new Object[]{startDate}).queryParam("endDate", new Object[]{endDate});
        Response response = target.request().get();
        Responses.validateResponse(response, Response.Status.OK);
        return (GetRecordsResponse)response.readEntity(GetRecordsResponse.class);
    }

    @Override
    public RecordObject createRecord(long datastoreId, Map<String, String> data) {
        HashMap<String, String> mapClone = new HashMap<String, String>(data);
        mapClone.put("datastoreId", (String)((Object)Long.valueOf(datastoreId)));
        Response response = this.recordsWebTarget.request().post(Entity.entity(mapClone, (String)"application/json"));
        Responses.validateResponse(response, Response.Status.OK);
        return (RecordObject)response.readEntity(RecordObject.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRecord(String id) {
        WebTarget target = this.recordsWebTarget.path("/" + id);
        try (Response response = target.request().delete();){
            Responses.validateResponse(response, Response.Status.OK);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    private static class AddAuthenticationHeadersFilter
    implements ClientRequestFilter {
        private final String username;
        private final String apiKey;

        AddAuthenticationHeadersFilter(String username, String apiKey) {
            this.username = username != null ? username : CredentialsFromPropertiesFile.getUsername();
            Objects.requireNonNull(this.username, "No Tierion username found");
            this.apiKey = apiKey != null ? apiKey : CredentialsFromPropertiesFile.getApiKey();
            Objects.requireNonNull(this.apiKey, "No Tierion apiKey found");
        }

        public void filter(ClientRequestContext request) throws IOException {
            request.getHeaders().add((Object)"X-Username", (Object)this.username);
            request.getHeaders().add((Object)"X-Api-Key", (Object)this.apiKey);
        }
    }
}

