/*
 * Decompiled with CFR 0.152.
 */
package cz.srayayay.tierion.hashapi;

import cz.srayayay.tierion.common.CredentialsFromPropertiesFile;
import cz.srayayay.tierion.common.Hashing;
import cz.srayayay.tierion.common.JsonHelper;
import cz.srayayay.tierion.common.Responses;
import cz.srayayay.tierion.common.model.BlockchainReceipt;
import cz.srayayay.tierion.hashapi.TierionHashApiClient;
import cz.srayayay.tierion.hashapi.model.HashReceiptResponse;
import cz.srayayay.tierion.hashapi.model.HashRequest;
import cz.srayayay.tierion.hashapi.model.HashResponse;
import cz.srayayay.tierion.hashapi.model.LoginRequest;
import cz.srayayay.tierion.hashapi.model.LoginResponse;
import cz.srayayay.tierion.hashapi.model.RefreshRequest;
import cz.srayayay.tierion.hashapi.model.subscriptions.BlockSubscription;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.util.Hex;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class V1TierionHashApiClient
implements TierionHashApiClient {
    private final Client client;
    private final AtomicReference<String> currentAccessToken = new AtomicReference();
    private final AtomicReference<String> currentRefreshToken = new AtomicReference();
    private static final String ROOT_TARGET_URL = "https://hashapi.tierion.com/v1";
    private final WebTarget rootWebTarget;
    private final WebTarget blockSubscriptionsWebTarget;
    private final ScheduledExecutorService executor;
    private final ClientRequestFilter authenticationHeaderAdder = request -> {
        if (this.currentAccessToken.get() != null) {
            request.getHeaders().add((Object)"Authorization", (Object)("Bearer " + this.currentAccessToken.get()));
        }
    };
    private final Runnable refreshTokenTask = new Runnable(){

        @Override
        public void run() {
            WebTarget target = V1TierionHashApiClient.this.rootWebTarget.path("/auth").path("/refresh");
            LoginResponse loginInfo = (LoginResponse)target.request().post(Entity.json((Object)new RefreshRequest((String)V1TierionHashApiClient.this.currentRefreshToken.get()))).readEntity(LoginResponse.class);
            V1TierionHashApiClient.this.currentAccessToken.set(loginInfo.getAccessToken());
            V1TierionHashApiClient.this.currentRefreshToken.set(loginInfo.getRefreshToken());
            if (loginInfo.getExpiresIn() != null && loginInfo.getExpiresIn() > 0L) {
                V1TierionHashApiClient.this.executor.schedule(V1TierionHashApiClient.this.refreshTokenTask, loginInfo.getExpiresIn() - 60L, TimeUnit.SECONDS);
            }
        }
    };

    public V1TierionHashApiClient(String username, String password, int connectionPoolSize) {
        this.client = new ResteasyClientBuilder().maxPooledPerRoute(connectionPoolSize).connectionPoolSize(connectionPoolSize).build().register((Object)this.authenticationHeaderAdder);
        this.rootWebTarget = this.client.target(ROOT_TARGET_URL);
        this.blockSubscriptionsWebTarget = this.rootWebTarget.path("/blocksubscriptions");
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.initialLogin(username, password);
    }

    public V1TierionHashApiClient(String username, String password) {
        this(username, password, 10);
    }

    public V1TierionHashApiClient(int connectionPoolSize) {
        this(null, null, connectionPoolSize);
    }

    public V1TierionHashApiClient() {
        this(null, null, 10);
    }

    private void initialLogin(String username, String password) {
        WebTarget target = this.rootWebTarget.path("/auth").path("/token");
        String actualUsername = username != null ? username : CredentialsFromPropertiesFile.getUsername();
        Objects.requireNonNull(actualUsername, "No Tierion username found");
        String actualPassword = password != null ? password : CredentialsFromPropertiesFile.getPassword();
        Objects.requireNonNull(actualPassword, "No Tierion password found");
        Response response = target.request().post(Entity.json((Object)new LoginRequest(actualUsername, actualPassword)));
        Responses.validateResponse(response, Response.Status.OK);
        LoginResponse loginInfo = (LoginResponse)response.readEntity(LoginResponse.class);
        this.currentAccessToken.set(loginInfo.getAccessToken());
        this.currentRefreshToken.set(loginInfo.getRefreshToken());
        if (loginInfo.getExpiresIn() != null && loginInfo.getExpiresIn() > 0L) {
            this.executor.schedule(this.refreshTokenTask, loginInfo.getExpiresIn() - 60L, TimeUnit.SECONDS);
        }
    }

    @Override
    public HashResponse submitHash(String hash) {
        WebTarget target = this.rootWebTarget.path("/hashitems");
        Response response = target.request().post(Entity.json((Object)new HashRequest(hash)));
        Responses.validateResponse(response, Response.Status.OK);
        return (HashResponse)response.readEntity(HashResponse.class);
    }

    @Override
    public HashResponse submitContent(byte[] text) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return this.submitHash(Hex.encodeHex((byte[])digest.digest(text)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public HashResponse submitFile(Path file) throws IOException {
        return this.submitHash(Hashing.hashFile(file));
    }

    @Override
    public BlockchainReceipt getReceipt(String receiptId) {
        WebTarget target = this.rootWebTarget.path("/receipts").path("/" + receiptId);
        Response response = target.request().get();
        Responses.validateResponse(response, Response.Status.OK);
        HashReceiptResponse responseEntity = (HashReceiptResponse)response.readEntity(HashReceiptResponse.class);
        return JsonHelper.fromJson(responseEntity.getReceipt(), BlockchainReceipt.class);
    }

    @Override
    public List<BlockSubscription> getAllBlockSubscriptions() {
        Response response = this.blockSubscriptionsWebTarget.request().get();
        Responses.validateResponse(response, Response.Status.OK);
        return (List)response.readEntity(new GenericType((Type)ParameterizedTypeImpl.make(List.class, new Type[]{BlockSubscription.class}, null)));
    }

    @Override
    public BlockSubscription getBlockSubscription(String id) {
        WebTarget target = this.blockSubscriptionsWebTarget.path("/" + id);
        Response response = target.request().get();
        Responses.validateResponse(response, Response.Status.OK);
        return (BlockSubscription)response.readEntity(BlockSubscription.class);
    }

    @Override
    public String createBlockSubscription(String callbackUrl, String label) {
        Response response = this.blockSubscriptionsWebTarget.request().post(Entity.json((Object)new BlockSubscription(callbackUrl, label)));
        Responses.validateResponse(response, Response.Status.CREATED);
        return ((BlockSubscription)response.readEntity(BlockSubscription.class)).getId();
    }

    @Override
    public BlockSubscription updateBlockSubscription(String id, String callbackUrl, String label) {
        WebTarget target = this.blockSubscriptionsWebTarget.path("/" + id);
        Response response = target.request().put(Entity.json((Object)new BlockSubscription(callbackUrl, label)));
        Responses.validateResponse(response, Response.Status.OK);
        return (BlockSubscription)response.readEntity(BlockSubscription.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteBlockSubscription(String id) {
        WebTarget target = this.blockSubscriptionsWebTarget.path("/" + id);
        try (Response response = target.request().delete();){
            Responses.validateResponse(response, Response.Status.OK);
        }
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }
}

