/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.console;

import cz.vutbr.fit.layout.api.ScriptObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;

public class SystemApi
implements ScriptObject {
    private BufferedReader rin;
    private PrintWriter wout;
    private PrintWriter werr;

    public String getVarName() {
        return "system";
    }

    public void setIO(Reader in, Writer out, Writer err) {
        this.rin = new BufferedReader(in);
        this.wout = new PrintWriter(out);
        this.werr = new PrintWriter(err);
    }

    public void mkdir(String dir) {
        try {
            File f = new File(dir);
            f.mkdir();
        }
        catch (Exception e) {
            this.werr.println("Couldn't create " + dir + ": " + e.getMessage());
        }
    }

    public String getProperty(String name) {
        return System.getProperty(name, "");
    }

    public String[] readLines(String inputFile) {
        try {
            Path filePath = new File(inputFile).toPath();
            Charset charset = Charset.defaultCharset();
            List<String> stringList = Files.readAllLines(filePath, charset);
            return stringList.toArray(new String[0]);
        }
        catch (IOException e) {
            this.werr.println("Couldn't read " + inputFile + ": " + e.getMessage());
            return new String[0];
        }
    }
}

