/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.console;

import cz.vutbr.fit.layout.console.process.ScriptableProcessor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import javax.script.ScriptException;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Console {
    private static Logger log = LoggerFactory.getLogger(Console.class);
    private ScriptableProcessor proc = new ScriptableProcessor();

    public Console() {
        this.proc.put("console", this);
        this.init();
    }

    public void interactiveSession(InputStream in, PrintStream out, PrintStream err) throws IOException {
        BufferedReader rin = new BufferedReader(new InputStreamReader(in));
        OutputStreamWriter wout = new OutputStreamWriter(out);
        OutputStreamWriter werr = new OutputStreamWriter(err);
        this.proc.setIO(rin, wout, werr);
        LineReader reader = LineReaderBuilder.builder().build();
        String histfile = System.getProperty("user.home") + "/.fitlayout/console_history";
        reader.setVariable("history-file", (Object)histfile);
        try {
            this.initSession();
        }
        catch (ScriptException e) {
            log.error(e.getMessage());
        }
        while (true) {
            this.proc.flushIO();
            out.println();
            try {
                String cmd = reader.readLine(this.prompt());
                Object result = this.proc.execCommand(cmd);
                if (result != null) {
                    out.println(result.toString());
                    continue;
                }
                out.println("undefined");
                continue;
            }
            catch (ScriptException e) {
                err.println(e.getMessage());
                continue;
            }
            catch (UserInterruptException e) {
                continue;
            }
            catch (EndOfFileException e) {
            }
            catch (Exception e) {
                err.println("Internal exception: " + e.getMessage());
                e.printStackTrace(err);
                continue;
            }
            break;
        }
        out.println();
    }

    protected String prompt() {
        return "FitLayout> ";
    }

    protected ScriptableProcessor getProcessor() {
        return this.proc;
    }

    protected void init() {
    }

    protected void initSession() throws ScriptException {
        this.proc.execInternal("init.js");
    }

    public void exit() {
        System.exit(0);
    }

    public void logToFile(String path, String text) {
        try (FileWriter fw = new FileWriter(path, true);
             BufferedWriter bw = new BufferedWriter(fw);
             PrintWriter out = new PrintWriter(bw);){
            out.println(text);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    public void truncateFile(String path) {
        try {
            FileWriter fw = new FileWriter(path, false);
            fw.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    public static void main(String[] args) {
        System.out.println("FitLayout interactive console");
        Console con = new Console();
        try {
            con.interactiveSession(System.in, System.out, System.err);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

