/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.console.process;

import cz.vutbr.fit.layout.api.AreaTreeOperator;
import cz.vutbr.fit.layout.api.ArtifactService;
import cz.vutbr.fit.layout.api.OutputDisplay;
import cz.vutbr.fit.layout.api.ParametrizedOperation;
import cz.vutbr.fit.layout.api.ScriptObject;
import cz.vutbr.fit.layout.api.ServiceManager;
import cz.vutbr.fit.layout.impl.BaseProcessor;
import cz.vutbr.fit.layout.io.ImageOutputDisplay;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.Page;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptableProcessor
extends BaseProcessor {
    private static Logger log = LoggerFactory.getLogger(ScriptableProcessor.class);
    private BufferedReader rin = new BufferedReader(new InputStreamReader(System.in));
    private PrintWriter wout = new PrintWriter(System.out);
    private PrintWriter werr = new PrintWriter(System.err);
    private ScriptEngine engine;

    public List<String> getOperatorIds() {
        return new ArrayList<String>(this.getOperators().keySet());
    }

    public List<String> getArtifactProviderIds(String artifactTypeIRI) {
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        IRI artifactType = vf.createIRI(artifactTypeIRI);
        return new ArrayList<String>(this.getArtifactProviders(artifactType).keySet());
    }

    public void setServiceParams(String serviceName, Map<String, Object> params) {
        ParametrizedOperation op = this.getServiceManager().findParmetrizedService(serviceName);
        if (op != null) {
            ServiceManager.setServiceParams((ParametrizedOperation)op, params);
        } else {
            log.error("setServiceParams: Unknown service: {}", (Object)serviceName);
        }
    }

    public Artifact processArtifact(Artifact input, String providerName, Map<String, Object> params) {
        ArtifactService provider = (ArtifactService)this.getArtifactServices().get(providerName);
        if (provider != null) {
            return this.processArtifact(input, provider, params);
        }
        log.error("Unknown box tree provider: " + providerName);
        return null;
    }

    public void apply(AreaTree atree, String operatorName, Map<String, Object> params) {
        AreaTreeOperator op = (AreaTreeOperator)this.getOperators().get(operatorName);
        if (op != null) {
            this.apply(atree, op, params);
        } else {
            log.error("Unknown operator " + operatorName);
        }
    }

    public void drawToImage(Page page, String path) {
        try {
            ImageOutputDisplay disp = new ImageOutputDisplay(page.getWidth(), page.getHeight());
            disp.drawPage(page);
            disp.saveTo(path);
        }
        catch (IOException e) {
            log.error("Couldn't write to " + path + ": " + e.getMessage());
        }
    }

    public void drawToImageWithAreas(Page page, AreaTree areaTree, String path, String areaNames) {
        try {
            ImageOutputDisplay disp = new ImageOutputDisplay(page.getWidth(), page.getHeight());
            disp.drawPage(page);
            this.showAreas((OutputDisplay)disp, areaTree.getRoot(), areaNames);
            disp.saveTo(path);
        }
        catch (IOException e) {
            log.error("Couldn't write to " + path + ": " + e.getMessage());
        }
    }

    private void showAreas(OutputDisplay disp, Area root, String nameSubstring) {
        if (nameSubstring == null || root.toString().contains(nameSubstring)) {
            disp.drawExtent(root);
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.showAreas(disp, (Area)root.getChildAt(i), nameSubstring);
        }
    }

    protected ScriptEngine getEngine() {
        if (this.engine == null) {
            ScriptEngineManager factory = new ScriptEngineManager();
            this.engine = factory.getEngineByName("JavaScript");
            this.engine.put("proc", (Object)this);
            try {
                this.engine.eval("if (typeof println == 'undefined') this.println = print;");
            }
            catch (ScriptException e) {
                e.printStackTrace();
            }
            Map scriptObjects = this.getServiceManager().findScriptObjects();
            for (Map.Entry obj : scriptObjects.entrySet()) {
                this.engine.put((String)obj.getKey(), obj.getValue());
            }
        }
        return this.engine;
    }

    public void setIO(Reader in, Writer out, Writer err) {
        this.rin = new BufferedReader(in);
        this.wout = new PrintWriter(out);
        this.werr = new PrintWriter(err);
        ScriptContext ctx = this.getEngine().getContext();
        ctx.setReader(this.rin);
        ctx.setWriter(this.wout);
        ctx.setErrorWriter(this.werr);
        for (ScriptObject obj : this.getServiceManager().findScriptObjects().values()) {
            obj.setIO(in, out, err);
        }
    }

    public void flushIO() {
        this.wout.flush();
        this.werr.flush();
    }

    public void put(String var, Object obj) {
        this.getEngine().put(var, obj);
    }

    public boolean execInternal(String scriptName) throws ScriptException {
        InputStream is;
        if (!((String)scriptName).startsWith("/")) {
            scriptName = "/" + (String)scriptName;
        }
        if ((is = ScriptableProcessor.class.getResourceAsStream((String)scriptName)) != null) {
            this.getEngine().eval(new InputStreamReader(is));
            return true;
        }
        log.error("Couldn't access internal script " + (String)scriptName);
        return false;
    }

    public Object execCommand(String command) throws ScriptException {
        return this.getEngine().eval(command);
    }
}

