/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.api;

import cz.vutbr.fit.layout.api.AreaTreeOperator;
import cz.vutbr.fit.layout.api.ArtifactRepository;
import cz.vutbr.fit.layout.api.ArtifactService;
import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.api.ParametrizedOperation;
import cz.vutbr.fit.layout.api.ScriptObject;
import cz.vutbr.fit.layout.api.Service;
import cz.vutbr.fit.layout.impl.DefaultArtifactRepository;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;

public class ServiceManager {
    private static ServiceManager globalInstance;
    private ArtifactRepository artifactRepository;
    private Map<String, ArtifactService> artifactServices;
    private Map<String, AreaTreeOperator> operators;
    private Map<String, ParametrizedOperation> parametrizedServices;
    private Map<String, ScriptObject> scriptObjects;

    public static ServiceManager instance() {
        if (globalInstance == null) {
            globalInstance = ServiceManager.createAndDiscover();
        }
        return globalInstance;
    }

    public static ServiceManager createAndDiscover() {
        ServiceManager mgr = new ServiceManager();
        mgr.initAndDiscover();
        return mgr;
    }

    protected void initAndDiscover() {
        this.artifactRepository = new DefaultArtifactRepository();
        this.scriptObjects = new HashMap<String, ScriptObject>();
        this.parametrizedServices = new HashMap<String, ParametrizedOperation>();
        this.artifactServices = this.loadServicesByType(ArtifactService.class);
        this.operators = this.loadServicesByType(AreaTreeOperator.class);
        this.loadScriptObjects();
    }

    public static ServiceManager create() {
        ServiceManager mgr = new ServiceManager();
        mgr.initEmpty();
        return mgr;
    }

    protected void initEmpty() {
        this.artifactRepository = new DefaultArtifactRepository();
        this.scriptObjects = new HashMap<String, ScriptObject>();
        this.parametrizedServices = new HashMap<String, ParametrizedOperation>();
        this.artifactServices = new HashMap<String, ArtifactService>();
        this.operators = new HashMap<String, AreaTreeOperator>();
    }

    public ArtifactRepository getArtifactRepository() {
        return this.artifactRepository;
    }

    public void setArtifactRepository(ArtifactRepository repository) {
        this.artifactRepository = repository;
    }

    public void addArtifactService(ArtifactService op) {
        this.addTypedOperation(op, this.artifactServices);
    }

    public Map<String, ArtifactService> findArtifactSevices() {
        return this.artifactServices;
    }

    public Map<String, ArtifactService> findArtifactProviders(IRI artifactType) {
        return this.artifactServices.entrySet().stream().filter(x -> artifactType.equals((Object)((ArtifactService)x.getValue()).getProduces())).collect(Collectors.toMap(x -> (String)x.getKey(), x -> (ArtifactService)x.getValue()));
    }

    public void addAreaTreeOperator(AreaTreeOperator op) {
        this.addTypedOperation(op, this.operators);
    }

    public Map<String, AreaTreeOperator> findAreaTreeOperators() {
        return this.operators;
    }

    public Map<String, ScriptObject> findScriptObjects() {
        return this.scriptObjects;
    }

    public <T extends Service> Map<String, T> loadServicesByType(Class<T> clazz) {
        ServiceLoader<T> loader = ServiceLoader.load(clazz);
        Iterator<T> it = loader.iterator();
        HashMap ret = new HashMap();
        while (it.hasNext()) {
            Service op = (Service)it.next();
            this.addTypedOperation(op, ret);
        }
        return ret;
    }

    private Map<String, ScriptObject> loadScriptObjects() {
        ServiceLoader<ScriptObject> loader = ServiceLoader.load(ScriptObject.class);
        for (ScriptObject op : loader) {
            this.addScriptObject(op.getVarName(), op);
        }
        return this.scriptObjects;
    }

    public static void setServiceParams(ParametrizedOperation op, Map<String, Object> params) {
        if (params != null) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                op.setParam(entry.getKey(), entry.getValue());
            }
        }
    }

    public static Map<String, Object> getServiceParams(ParametrizedOperation op) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (Parameter param : op.getParams()) {
            ret.put(param.getName(), op.getParam(param.getName()));
        }
        return ret;
    }

    public Map<String, ParametrizedOperation> getParametrizedServices() {
        return this.parametrizedServices;
    }

    public ParametrizedOperation findParmetrizedService(String id) {
        if (this.parametrizedServices == null) {
            return null;
        }
        return this.parametrizedServices.get(id);
    }

    private <T extends Service> void addTypedOperation(T op, Map<String, T> dest) {
        op.setServiceManager(this);
        dest.put(op.getId(), op);
        if (op instanceof ParametrizedOperation) {
            this.addParametrizedService(op.getId(), (ParametrizedOperation)((Object)op));
        }
        if (op instanceof ScriptObject) {
            this.addScriptObject(((ScriptObject)((Object)op)).getVarName(), (ScriptObject)((Object)op));
        }
    }

    private void addParametrizedService(String id, ParametrizedOperation op) {
        this.parametrizedServices.put(id, op);
    }

    public void addScriptObject(String id, ScriptObject op) {
        if (!this.scriptObjects.containsKey(id)) {
            this.scriptObjects.put(id, op);
        }
    }

    public <T> T findByClass(Collection<?> services, Class<T> clazz) {
        for (Object serv : services) {
            if (!clazz.isInstance(serv)) continue;
            return clazz.cast(serv);
        }
        return null;
    }
}

