/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.impl;

import cz.vutbr.fit.layout.impl.DefaultContentRect;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.ChunkSet;
import cz.vutbr.fit.layout.model.Color;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.model.Tag;
import cz.vutbr.fit.layout.model.TextChunk;
import cz.vutbr.fit.layout.model.TextStyle;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultTextChunk
extends DefaultContentRect
implements TextChunk {
    private ChunkSet chunkSet;
    private String text = "";
    private Area sourceArea;
    private Box sourceBox;
    private Color effectiveBackgroundColor;
    private String name = "<chunk>";
    private Map<Tag, Float> tags;

    public DefaultTextChunk() {
        this.setBounds(new Rectangular());
        this.tags = new HashMap<Tag, Float>();
    }

    public DefaultTextChunk(Rectangular r, Area sourceArea, Box sourceBox) {
        this.sourceArea = sourceArea;
        this.sourceBox = sourceBox;
        this.setBounds(r);
        this.tags = new HashMap<Tag, Float>();
        this.copyStyle(sourceArea);
    }

    @Override
    public ChunkSet getChunkSet() {
        return this.chunkSet;
    }

    public void setChunkSet(ChunkSet chunkSet) {
        this.chunkSet = chunkSet;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Area getSourceArea() {
        return this.sourceArea;
    }

    public void setSourceArea(Area sourceArea) {
        this.sourceArea = sourceArea;
        this.copyStyle(sourceArea);
    }

    @Override
    public Box getSourceBox() {
        return this.sourceBox;
    }

    public void setSourceBox(Box sourceBox) {
        this.sourceBox = sourceBox;
    }

    @Override
    public Color getEffectiveBackgroundColor() {
        return this.effectiveBackgroundColor;
    }

    public void setEffectiveBackgroundColor(Color effectiveBackgroundColor) {
        this.effectiveBackgroundColor = effectiveBackgroundColor;
    }

    @Override
    public void addTag(Tag tag, float support) {
        Float oldsupport = this.tags.get(tag);
        if (oldsupport == null || oldsupport.floatValue() < support) {
            this.tags.put(tag, Float.valueOf(support));
        }
    }

    @Override
    public boolean hasTag(Tag tag) {
        return this.tags.get(tag) != null;
    }

    @Override
    public boolean hasTag(Tag tag, float minSupport) {
        Float sp = this.tags.get(tag);
        return sp != null && sp.floatValue() >= minSupport;
    }

    @Override
    public Set<Tag> getSupportedTags(float minSupport) {
        HashSet<Tag> ret = new HashSet<Tag>();
        for (Map.Entry<Tag, Float> entry : this.tags.entrySet()) {
            if (!(entry.getValue().floatValue() >= minSupport)) continue;
            ret.add(entry.getKey());
        }
        return ret;
    }

    @Override
    public float getTagSupport(Tag tag) {
        Float f = this.tags.get(tag);
        if (f == null) {
            return 0.0f;
        }
        return f.floatValue();
    }

    @Override
    public Tag getMostSupportedTag() {
        float max = -1.0f;
        Tag ret = null;
        for (Map.Entry<Tag, Float> entry : this.tags.entrySet()) {
            if (!(entry.getValue().floatValue() > max)) continue;
            max = entry.getValue().floatValue();
            ret = entry.getKey();
        }
        return ret;
    }

    public void removeAllTags(Collection<Tag> c) {
        for (Tag t : c) {
            this.tags.remove(t);
        }
    }

    @Override
    public void removeTag(Tag tag) {
        this.tags.remove(tag);
    }

    @Override
    public Map<Tag, Float> getTags() {
        return this.tags;
    }

    protected void copyStyle(Area src) {
        this.setBackgroundColor(src.getBackgroundColor() == null ? null : new Color(src.getBackgroundColor().getRed(), src.getBackgroundColor().getGreen(), src.getBackgroundColor().getBlue()));
        this.setEffectiveBackgroundColor(src.getEffectiveBackgroundColor());
        this.setBackgroundSeparated(src.isBackgroundSeparated());
        this.setTextStyle(new TextStyle(src.getTextStyle()));
        this.setBackgroundSeparated(src.isBackgroundSeparated());
    }
}

