/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.provider;

import cz.vutbr.fit.layout.api.AreaTreeOperator;
import cz.vutbr.fit.layout.api.ParametrizedOperation;
import cz.vutbr.fit.layout.api.ServiceException;
import cz.vutbr.fit.layout.impl.BaseArtifactService;
import cz.vutbr.fit.layout.impl.DefaultAreaTree;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.ontology.SEGM;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorApplicationProvider
extends BaseArtifactService {
    private static Logger log = LoggerFactory.getLogger(OperatorApplicationProvider.class);
    String operatorList;
    private List<AreaTreeOperator> operators;

    public OperatorApplicationProvider() {
    }

    public OperatorApplicationProvider(String operatorList) {
        this.setOperatorList(operatorList);
    }

    public String getOperatorList() {
        return this.operatorList;
    }

    public void setOperatorList(String operatorList) {
        String[] ids;
        this.operatorList = operatorList;
        for (String id : ids = operatorList.split(",")) {
            ParametrizedOperation serv = this.getServiceManager().findParmetrizedService(id.trim());
            if (serv != null && serv instanceof AreaTreeOperator) {
                this.operators.add((AreaTreeOperator)serv);
                continue;
            }
            log.error("Couldn't find operator '{}'", (Object)id.trim());
        }
    }

    public List<AreaTreeOperator> getOperators() {
        return this.operators;
    }

    public void setOperators(List<AreaTreeOperator> operators) {
        this.operators = operators;
    }

    @Override
    public String getId() {
        return "FitLayout.ApplyOperators";
    }

    @Override
    public String getName() {
        return "Operator application provider";
    }

    @Override
    public String getDescription() {
        return "Applies a list of operators on an area tree";
    }

    @Override
    public IRI getConsumes() {
        return SEGM.AreaTree;
    }

    @Override
    public IRI getProduces() {
        return SEGM.AreaTree;
    }

    @Override
    public Artifact process(Artifact input) throws ServiceException {
        if (input != null && input instanceof AreaTree) {
            return this.createAreaTree((AreaTree)input);
        }
        throw new ServiceException("Source artifact not provider or not an area tree");
    }

    private AreaTree createAreaTree(AreaTree input) {
        DefaultAreaTree ret = new DefaultAreaTree(input);
        Area root = ret.createArea(input.getRoot());
        this.recursiveCopyChildren(ret, root, input.getRoot());
        ret.setParentIri(input.getIri());
        ret.setLabel(this.getId());
        ret.setCreator(this.getId());
        ret.setCreatorParams(this.getOperatorDescription());
        for (AreaTreeOperator op : this.getOperators()) {
            op.apply(ret);
        }
        return ret;
    }

    private void recursiveCopyChildren(AreaTree atree, Area destArea, Area srcArea) {
        for (Area src : srcArea.getChildren()) {
            Area dest = atree.createArea(src);
            destArea.appendChild(dest);
            this.recursiveCopyChildren(atree, dest, src);
        }
    }

    private String getOperatorDescription() {
        StringBuilder ret = new StringBuilder();
        for (AreaTreeOperator op : this.getOperators()) {
            if (ret.length() != 0) {
                ret.append(" + ");
            }
            ret.append(op.getId());
            ret.append('(').append(op.getParamString()).append(')');
        }
        return ret.toString();
    }
}

