/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.impl;

import cz.vutbr.fit.layout.api.AreaTreeOperator;
import cz.vutbr.fit.layout.api.ArtifactRepository;
import cz.vutbr.fit.layout.api.ArtifactService;
import cz.vutbr.fit.layout.api.ParametrizedOperation;
import cz.vutbr.fit.layout.api.ServiceException;
import cz.vutbr.fit.layout.api.ServiceManager;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Artifact;
import java.util.Map;
import org.eclipse.rdf4j.model.IRI;

public abstract class BaseProcessor {
    private ServiceManager serviceManager = this.createServiceManager();

    public BaseProcessor() {
    }

    public BaseProcessor(ArtifactRepository repository) {
        this.serviceManager.setArtifactRepository(repository);
    }

    protected ServiceManager createServiceManager() {
        return ServiceManager.createAndDiscover();
    }

    public ArtifactRepository getRepository() {
        return this.serviceManager.getArtifactRepository();
    }

    public void setRepository(ArtifactRepository repository) {
        this.serviceManager.setArtifactRepository(repository);
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public Map<String, ArtifactService> getArtifactServices() {
        return this.getServiceManager().findArtifactSevices();
    }

    public Map<String, ArtifactService> getArtifactProviders(IRI artifactType) {
        return this.getServiceManager().findArtifactProviders(artifactType);
    }

    public Map<String, AreaTreeOperator> getOperators() {
        return this.getServiceManager().findAreaTreeOperators();
    }

    public Artifact processArtifact(Artifact input, ArtifactService provider, Map<String, Object> params) throws ServiceException {
        if (provider instanceof ParametrizedOperation) {
            ServiceManager.setServiceParams((ParametrizedOperation)((Object)provider), params);
        }
        return provider.process(input);
    }

    public void apply(AreaTree atree, AreaTreeOperator op, Map<String, Object> params) {
        ServiceManager.setServiceParams(op, params);
        op.apply(atree);
    }
}

