/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.impl;

import cz.vutbr.fit.layout.impl.DefaultTreeNode;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.LogicalArea;
import cz.vutbr.fit.layout.model.Tag;
import java.util.List;
import java.util.Vector;

public class DefaultLogicalArea
extends DefaultTreeNode<LogicalArea>
implements LogicalArea {
    private List<Area> areas = new Vector<Area>();
    private String text;
    private Tag mainTag;

    public DefaultLogicalArea() {
        super(LogicalArea.class);
        this.text = "";
    }

    public DefaultLogicalArea(Area src) {
        super(LogicalArea.class);
        this.areas.add(src);
        this.text = src.getText();
    }

    public DefaultLogicalArea(Area src, String text) {
        super(LogicalArea.class);
        this.areas.add(src);
        this.text = text;
    }

    @Override
    public void addArea(Area a) {
        this.areas.add(a);
    }

    @Override
    public List<Area> getAreas() {
        return this.areas;
    }

    @Override
    public Area getFirstArea() {
        return (Area)((Vector)this.areas).firstElement();
    }

    @Override
    public int getAreaCount() {
        return this.areas.size();
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setMainTag(Tag mainTag) {
        this.mainTag = mainTag;
    }

    @Override
    public Tag getMainTag() {
        return this.mainTag;
    }

    public String toString() {
        String tagstr = this.mainTag == null ? "---" : this.mainTag.getValue();
        return "(" + tagstr + ") " + this.getText();
    }

    @Override
    public LogicalArea findArea(Area area) {
        LogicalArea ret = null;
        for (int i = 0; i < this.getChildCount() && ret == null; ++i) {
            ret = ((LogicalArea)this.getChildAt(i)).findArea(area);
        }
        if (ret == null && this.getAreas().contains(area)) {
            ret = this;
        }
        return ret;
    }
}

