/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.model;

public class TextStyle {
    private float fontSizeSum;
    private float fontWeightSum;
    private float fontStyleSum;
    private float underlineSum;
    private float lineThroughSum;
    private int contentLength;

    public TextStyle() {
        this.reset();
    }

    public TextStyle(TextStyle src) {
        this.fontSizeSum = src.fontSizeSum;
        this.fontWeightSum = src.fontWeightSum;
        this.fontStyleSum = src.fontStyleSum;
        this.underlineSum = src.underlineSum;
        this.lineThroughSum = src.lineThroughSum;
        this.contentLength = src.contentLength;
    }

    public float getFontSize() {
        if (this.contentLength == 0) {
            return 0.0f;
        }
        return this.fontSizeSum / (float)this.contentLength;
    }

    public float getFontWeight() {
        if (this.contentLength == 0) {
            return 0.0f;
        }
        return this.fontWeightSum / (float)this.contentLength;
    }

    public float getFontStyle() {
        if (this.contentLength == 0) {
            return 0.0f;
        }
        return this.fontStyleSum / (float)this.contentLength;
    }

    public float getUnderline() {
        if (this.contentLength == 0) {
            return 0.0f;
        }
        return this.underlineSum / (float)this.contentLength;
    }

    public float getLineThrough() {
        if (this.contentLength == 0) {
            return 0.0f;
        }
        return this.lineThroughSum / (float)this.contentLength;
    }

    public float getFontSizeSum() {
        return this.fontSizeSum;
    }

    public void setFontSizeSum(float fontSizeSum) {
        this.fontSizeSum = fontSizeSum;
    }

    public float getFontWeightSum() {
        return this.fontWeightSum;
    }

    public void setFontWeightSum(float fontWeightSum) {
        this.fontWeightSum = fontWeightSum;
    }

    public float getFontStyleSum() {
        return this.fontStyleSum;
    }

    public void setFontStyleSum(float fontStyleSum) {
        this.fontStyleSum = fontStyleSum;
    }

    public float getUnderlineSum() {
        return this.underlineSum;
    }

    public void setUnderlineSum(float underlineSum) {
        this.underlineSum = underlineSum;
    }

    public float getLineThroughSum() {
        return this.lineThroughSum;
    }

    public void setLineThroughSum(float lineThroughSum) {
        this.lineThroughSum = lineThroughSum;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public void updateAverages(TextStyle other) {
        this.fontSizeSum += other.getFontSizeSum();
        this.fontWeightSum += other.getFontWeightSum();
        this.fontStyleSum += other.getFontStyleSum();
        this.underlineSum += other.getUnderlineSum();
        this.lineThroughSum += other.getLineThroughSum();
        this.contentLength += other.getContentLength();
    }

    public void reset() {
        this.fontSizeSum = 0.0f;
        this.fontWeightSum = 0.0f;
        this.fontStyleSum = 0.0f;
        this.underlineSum = 0.0f;
        this.lineThroughSum = 0.0f;
        this.contentLength = 0;
    }
}

