/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.provider;

import cz.vutbr.fit.layout.api.AreaTreeOperator;
import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.api.ServiceException;
import cz.vutbr.fit.layout.impl.BaseArtifactService;
import cz.vutbr.fit.layout.impl.DefaultAreaTree;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.ontology.SEGM;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;

public class OperatorWrapperProvider
extends BaseArtifactService {
    private AreaTreeOperator operator;

    public OperatorWrapperProvider(AreaTreeOperator operator) {
        this.operator = operator;
    }

    public AreaTreeOperator getOperator() {
        return this.operator;
    }

    @Override
    public String getId() {
        return this.operator.getId();
    }

    @Override
    public String getName() {
        return this.operator.getName();
    }

    @Override
    public String getDescription() {
        return this.operator.getDescription();
    }

    @Override
    public String getCategory() {
        return this.operator.getCategory();
    }

    @Override
    public List<Parameter> defineParams() {
        return this.operator.getParams();
    }

    @Override
    public boolean setParam(String name, Object value) {
        return this.operator.setParam(name, value);
    }

    @Override
    public Object getParam(String name) {
        return this.operator.getParam(name);
    }

    @Override
    public IRI getConsumes() {
        return SEGM.AreaTree;
    }

    @Override
    public IRI getProduces() {
        return SEGM.AreaTree;
    }

    @Override
    public Artifact process(Artifact input) throws ServiceException {
        if (input != null && input instanceof AreaTree) {
            return this.createAreaTree((AreaTree)input);
        }
        throw new ServiceException("Source artifact not provider or not an area tree");
    }

    private AreaTree createAreaTree(AreaTree input) {
        DefaultAreaTree ret = new DefaultAreaTree(input);
        Area root = ret.createArea(input.getRoot());
        this.recursiveCopyChildren(ret, root, input.getRoot());
        ret.setParentIri(input.getIri());
        ret.setLabel(this.getId());
        ret.setCreator(this.getId());
        ret.setCreatorParams(this.getParamString());
        this.operator.apply(ret);
        return ret;
    }

    private void recursiveCopyChildren(AreaTree atree, Area destArea, Area srcArea) {
        for (Area src : srcArea.getChildren()) {
            Area dest = atree.createArea(src);
            destArea.appendChild(dest);
            this.recursiveCopyChildren(atree, dest, src);
        }
    }
}

