/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.impl;

import cz.vutbr.fit.layout.impl.DefaultGridTopology;
import cz.vutbr.fit.layout.impl.DefaultTreeContentRect;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTopology;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Border;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Color;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.model.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultArea
extends DefaultTreeContentRect<Area>
implements Area {
    private String name;
    private AreaTree areaTree;
    private AreaTopology topology;
    private List<Box> boxes;
    private Map<Tag, Float> tags;
    private Rectangular contentBounds;
    private int level = 0;
    private boolean hsep;
    private boolean vsep;
    private boolean explicitlySeparated;

    public DefaultArea(Rectangular r) {
        super(Area.class);
        this.name = null;
        this.boxes = new ArrayList<Box>();
        this.tags = new HashMap<Tag, Float>();
        this.setBounds(new Rectangular(r));
        this.setBackgroundColor(null);
        this.hsep = false;
        this.vsep = false;
        this.level = 0;
    }

    public DefaultArea(Area src) {
        super(Area.class, src);
        this.name = src.getName() == null ? null : new String(src.getName());
        this.boxes = new ArrayList<Box>(src.getBoxes());
        this.tags = new HashMap<Tag, Float>();
        this.contentBounds = src.getBounds() == null ? null : new Rectangular(src.getBounds());
        this.vsep = src.isVerticalSeparator();
        this.hsep = src.isHorizontalSeparator();
        this.level = src.getLevel();
    }

    public DefaultArea(Box box) {
        this(box.getBounds());
        this.setPageIri(box.getPageIri());
        this.addBox(box);
        this.setBounds(new Rectangular(this.contentBounds));
        this.setName(this.getBoxDescription(box));
        this.setBackgroundColor(box.getBackgroundColor());
        this.setBackgroundSeparated(box.isBackgroundSeparated());
        for (Border.Side side : Border.Side.values()) {
            this.setBorderStyle(side, box.getBorderStyle(side));
        }
    }

    public DefaultArea(List<Box> boxList) {
        this(boxList.get(0));
        for (Box box : boxList) {
            this.addBox(box);
        }
        this.setBounds(new Rectangular(this.contentBounds));
    }

    @Override
    public void childrenChanged() {
        super.childrenChanged();
        this.invalidateTopology();
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AreaTree getAreaTree() {
        return this.areaTree;
    }

    @Override
    public void setAreaTree(AreaTree areaTree) {
        this.areaTree = areaTree;
    }

    public Rectangular getContentBounds() {
        return this.contentBounds;
    }

    @Override
    public void move(int xofs, int yofs) {
        this.getContentBounds().move(xofs, yofs);
        super.move(xofs, yofs);
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public AreaTopology getTopology() {
        if (this.topology == null) {
            this.topology = this.createTopology();
        }
        return this.topology;
    }

    @Override
    public void updateTopologies() {
        if (this.topology != null) {
            this.topology.update();
        }
    }

    protected AreaTopology createTopology() {
        return new DefaultGridTopology(this);
    }

    protected void invalidateTopology() {
        if (this.topology != null) {
            ((DefaultGridTopology)this.topology).setDirty(true);
        }
    }

    @Override
    public Color getEffectiveBackgroundColor() {
        if (this.getBackgroundColor() != null) {
            return this.getBackgroundColor();
        }
        if (this.getParent() != null) {
            return ((Area)this.getParent()).getEffectiveBackgroundColor();
        }
        return Color.WHITE;
    }

    @Override
    public void appendChild(Area child) {
        child.setAreaTree(this.areaTree);
        super.appendChild(child);
        this.getBounds().expandToEnclose(child.getBounds());
    }

    @Override
    public void insertChild(Area child, int index) throws IndexOutOfBoundsException {
        super.insertChild(child, index);
    }

    @Override
    public String getText() {
        Object ret = "";
        if (this.isLeaf()) {
            ret = this.getBoxText();
        } else {
            for (int i = 0; i < this.getChildCount(); ++i) {
                ret = (String)ret + ((Area)this.getChildAt(i)).getText();
            }
        }
        return ret;
    }

    @Override
    public String getText(String separator) {
        Object ret = "";
        if (this.isLeaf()) {
            ret = this.getBoxText();
        } else {
            for (int i = 0; i < this.getChildCount(); ++i) {
                if (((Area)this.getChildAt(i)).isLeaf() && !((String)ret).isEmpty()) {
                    ret = (String)ret + separator;
                }
                ret = (String)ret + ((Area)this.getChildAt(i)).getText(separator);
            }
        }
        return ret;
    }

    @Override
    public boolean isReplaced() {
        boolean empty = true;
        for (Box root : this.boxes) {
            empty = false;
            if (root.getType() == Box.Type.REPLACED_CONTENT) continue;
            return false;
        }
        return !empty;
    }

    @Override
    public void addBox(Box box) {
        this.boxes.add(box);
        this.childrenChanged();
        Rectangular sb = box.getVisualBounds();
        if (this.contentBounds == null) {
            this.contentBounds = new Rectangular(sb);
        } else if (sb.getWidth() > 0 && sb.getHeight() > 0) {
            this.contentBounds.expandToEnclose(sb);
        }
    }

    @Override
    public List<Box> getBoxes() {
        return this.boxes;
    }

    @Override
    public List<Box> getAllBoxes() {
        ArrayList<Box> ret = new ArrayList<Box>();
        this.recursiveFindBoxes(this, ret);
        return ret;
    }

    private void recursiveFindBoxes(Area root, List<Box> result) {
        result.addAll(root.getBoxes());
        for (int i = 0; i < root.getChildCount(); ++i) {
            this.recursiveFindBoxes((Area)root.getChildAt(i), result);
        }
    }

    public String getBoxText() {
        StringBuilder ret = new StringBuilder();
        boolean start = true;
        Iterator<Box> it = this.boxes.iterator();
        while (it.hasNext()) {
            if (!start) {
                ret.append(' ');
            } else {
                start = false;
            }
            ret.append(it.next().getText());
        }
        return ret.toString();
    }

    public void removeBox(Box box) {
        this.boxes.remove(box);
    }

    public void removeBoxes(Collection<Box> box) {
        this.boxes.removeAll(box);
        this.childrenChanged();
    }

    @Override
    public void addTag(Tag tag, float support) {
        Float oldsupport = this.tags.get(tag);
        if (oldsupport == null || oldsupport.floatValue() < support) {
            this.tags.put(tag, Float.valueOf(support));
        }
    }

    @Override
    public boolean hasTag(Tag tag) {
        return this.tags.get(tag) != null;
    }

    @Override
    public boolean hasTag(Tag tag, float minSupport) {
        Float sp = this.tags.get(tag);
        return sp != null && sp.floatValue() >= minSupport;
    }

    @Override
    public Set<Tag> getSupportedTags(float minSupport) {
        HashSet<Tag> ret = new HashSet<Tag>();
        for (Map.Entry<Tag, Float> entry : this.tags.entrySet()) {
            if (!(entry.getValue().floatValue() >= minSupport)) continue;
            ret.add(entry.getKey());
        }
        return ret;
    }

    @Override
    public float getTagSupport(Tag tag) {
        Float f = this.tags.get(tag);
        if (f == null) {
            return 0.0f;
        }
        return f.floatValue();
    }

    @Override
    public Tag getMostSupportedTag() {
        float max = -1.0f;
        Tag ret = null;
        for (Map.Entry<Tag, Float> entry : this.tags.entrySet()) {
            if (!(entry.getValue().floatValue() > max)) continue;
            max = entry.getValue().floatValue();
            ret = entry.getKey();
        }
        return ret;
    }

    public void removeAllTags(Collection<Tag> c) {
        for (Tag t : c) {
            this.tags.remove(t);
        }
    }

    @Override
    public void removeTag(Tag tag) {
        this.tags.remove(tag);
    }

    public boolean containsTag(Tag tag) {
        if (this.hasTag(tag)) {
            return true;
        }
        for (Area child : this.getChildren()) {
            if (!child.hasTag(tag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<Tag, Float> getTags() {
        return this.tags;
    }

    public void setHorizontalSeparator(boolean hsep) {
        this.hsep = hsep;
    }

    @Override
    public boolean isHorizontalSeparator() {
        return this.hsep;
    }

    public void setVerticalSeparator(boolean vsep) {
        this.hsep = vsep;
    }

    @Override
    public boolean isVerticalSeparator() {
        return this.vsep;
    }

    @Override
    public boolean isSeparator() {
        return this.isHorizontalSeparator() || this.isVerticalSeparator();
    }

    @Override
    public boolean isExplicitlySeparated() {
        return this.explicitlySeparated;
    }

    @Override
    public void setExplicitlySeparated(boolean explicitlySeparated) {
        this.explicitlySeparated = explicitlySeparated;
    }

    @Override
    public Area createSuperArea(Rectangular gp, List<Area> selected, String name) {
        if (this.getChildCount() > 1 && selected.size() > 1 && selected.size() != this.getChildCount()) {
            Rectangular abspos = this.getTopology().toPixelPosition(gp);
            abspos.move(this.getX1(), this.getY1());
            Area area = this.getAreaTree().createArea(abspos);
            area.setName(name);
            int index = this.getIndex(selected.get(0));
            this.insertChild(area, index);
            area.appendChildren(selected);
            area.updateTopologies();
            this.updateTopologies();
            return area;
        }
        return null;
    }

    @Override
    public void insertParent(Area newParent, Area child) {
        int index = this.getIndex(child);
        if (index == -1) {
            throw new IllegalArgumentException("child must be a child area");
        }
        this.insertChild(newParent, index);
        newParent.appendChild(child);
    }

    @Override
    public Area copy() {
        DefaultArea ret = new DefaultArea(this);
        if (this.getParent() != null) {
            int ndx = ((Area)this.getParent()).getIndex(this);
            ((Area)this.getParent()).insertChild(ret, ndx + 1);
        }
        return ret;
    }

    public String toString() {
        Object bs = "";
        if (this.hasTopBorder()) {
            bs = (String)bs + "^";
        }
        if (this.hasLeftBorder()) {
            bs = (String)bs + "<";
        }
        if (this.hasRightBorder()) {
            bs = (String)bs + ">";
        }
        if (this.hasBottomBorder()) {
            bs = (String)bs + "_";
        }
        if (this.isBackgroundSeparated()) {
            bs = (String)bs + "*";
        }
        if (this.name != null) {
            return (String)bs + " " + this.name + " " + this.getBounds().toString();
        }
        return (String)bs + " <area> " + this.getBounds().toString();
    }

    @Override
    public void setGridPosition(Rectangular gp) {
        if (this.getParent() != null) {
            ((Area)this.getParent()).getTopology().setPosition(this, gp);
        }
    }

    @Override
    public Rectangular getGridPosition() {
        if (this.getParent() != null) {
            return ((Area)this.getParent()).getTopology().getPosition(this);
        }
        return new Rectangular(0, 0, 0, 0);
    }

    protected String getBoxDescription(Box box) {
        if (box.getType() == Box.Type.TEXT_CONTENT) {
            return box.getText();
        }
        String cls = box.getAttribute("class");
        String id = box.getAttribute("id");
        StringBuilder ret = new StringBuilder("<");
        ret.append(box.getTagName());
        if (id != null) {
            ret.append(" id=").append(id);
        }
        if (cls != null) {
            ret.append(" class=").append(cls);
        }
        ret.append(">");
        return ret.toString();
    }

    @Override
    protected void recomputeTextStyle() {
        this.getTextStyle().reset();
        if (this.isLeaf()) {
            for (Box box : this.getBoxes()) {
                this.getTextStyle().updateAverages(box.getTextStyle());
            }
        } else {
            for (Area area : this.getChildren()) {
                this.getTextStyle().updateAverages(area.getTextStyle());
            }
        }
    }
}

