/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.impl;

import cz.vutbr.fit.layout.api.ArtifactRepository;
import cz.vutbr.fit.layout.api.IRIDecoder;
import cz.vutbr.fit.layout.impl.DefaultIRIDecoder;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.LogicalAreaTree;
import cz.vutbr.fit.layout.model.Page;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class DefaultArtifactRepository
implements ArtifactRepository {
    private static ValueFactory vf = SimpleValueFactory.getInstance();
    private int idCounter = 1;
    private IRIDecoder iriDecoder = new DefaultIRIDecoder();
    private Map<IRI, Artifact> repo = new HashMap<IRI, Artifact>();

    @Override
    public Collection<IRI> getArtifactIRIs() {
        return this.repo.keySet();
    }

    @Override
    public Collection<Artifact> getArtifactInfo() {
        return this.repo.values();
    }

    @Override
    public Artifact getArtifact(IRI artifactIri) {
        return this.repo.get(artifactIri);
    }

    @Override
    public void addArtifact(Artifact artifact) {
        if (artifact.getIri() == null) {
            artifact.setIri(this.createArtifactIri(artifact));
        }
        this.repo.put(artifact.getIri(), artifact);
    }

    @Override
    public IRI createArtifactIri(Artifact artifact) {
        String atype = artifact instanceof Page ? "boxtree" : (artifact instanceof AreaTree ? "areatree" : (artifact instanceof LogicalAreaTree ? "logicaltree" : "artifact"));
        return vf.createIRI("urn:" + atype + ":" + String.valueOf(this.idCounter++));
    }

    @Override
    public void replaceArtifact(IRI artifactIri, Artifact artifact) {
        artifact.setIri(artifactIri);
        this.repo.put(artifactIri, artifact);
    }

    @Override
    public void removeArtifact(IRI artifactIri) {
        ArrayList<Artifact> derived = new ArrayList<Artifact>();
        this.findDerivedArtifacts(artifactIri, derived);
        for (Artifact a : derived) {
            this.repo.remove(a.getIri());
        }
        this.repo.remove(artifactIri);
    }

    private void findDerivedArtifacts(IRI artifactIri, List<Artifact> dest) {
        for (Artifact a : this.repo.values()) {
            if (a.getParentIri() != artifactIri) continue;
            this.findDerivedArtifacts(a.getIri(), dest);
            dest.add(a);
        }
    }

    @Override
    public void clear() {
        this.repo.clear();
    }

    @Override
    public IRIDecoder getIriDecoder() {
        return this.iriDecoder;
    }

    @Override
    public void disconnect() {
    }
}

