/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.impl;

import cz.vutbr.fit.layout.api.AreaUtils;
import cz.vutbr.fit.layout.api.OutputDisplay;
import cz.vutbr.fit.layout.impl.AreaListGridTopology;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.model.Rectangular;
import java.util.List;

public class DefaultGridTopology
extends AreaListGridTopology {
    private Area area;
    private boolean dirty;

    public DefaultGridTopology(Area area) {
        super(AreaUtils.getChildrenAsContentRects(area), false);
        this.area = area;
        this.update();
    }

    public Area getArea() {
        return this.area;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public void setAreas(List<ContentRect> areas) {
        if (this.getAreas() != areas) {
            this.dirty = true;
        }
        super.setAreas(areas);
    }

    @Override
    public Rectangular getPosition(ContentRect area) {
        this.checkDirty();
        return super.getPosition(area);
    }

    @Override
    public ContentRect findAreaAt(int x, int y) {
        this.checkDirty();
        return super.findAreaAt(x, y);
    }

    @Override
    public Rectangular toPixelPosition(Rectangular gp) {
        this.checkDirty();
        return super.toPixelPosition(gp);
    }

    @Override
    public Rectangular toPixelPositionAbsolute(Rectangular gp) {
        this.checkDirty();
        return super.toPixelPositionAbsolute(gp);
    }

    @Override
    public void drawLayout(OutputDisplay disp) {
        this.checkDirty();
        super.drawLayout(disp);
    }

    @Override
    public void update() {
        this.setAreas(AreaUtils.getChildrenAsContentRects(this.area));
        this.dirty = false;
        super.update();
    }

    @Override
    protected Rectangular computeAreaBounds() {
        return this.area.getBounds();
    }

    private void checkDirty() {
        if (this.dirty) {
            this.update();
        }
    }
}

