/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.impl;

import cz.vutbr.fit.layout.model.GenericTreeNode;
import java.util.ArrayList;
import java.util.List;

public class DefaultTreeNode<T extends GenericTreeNode<T>>
implements GenericTreeNode<T> {
    private T myself;
    private T root;
    private T parent = null;
    private List<T> children = new ArrayList<T>();

    public DefaultTreeNode(Class<T> myType) {
        this.myself = (GenericTreeNode)myType.cast(this);
        this.root = this.myself;
    }

    @Override
    public T getParent() {
        return this.parent;
    }

    @Override
    public void setParent(T parent) {
        this.parent = parent;
    }

    @Override
    public T getRoot() {
        return this.root;
    }

    @Override
    public void setRoot(T root) {
        this.root = root;
    }

    @Override
    public boolean isRoot() {
        return this.getRoot() == this;
    }

    @Override
    public List<T> getChildren() {
        return this.children;
    }

    @Override
    public int getChildCount() {
        return this.getChildren().size();
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    private void addChild(T child) {
        if (child.getParent() != null) {
            child.getParent().removeChild(child);
        }
        child.setParent(this.myself);
        child.setRoot(this.getRoot());
        this.children.add(child);
    }

    @Override
    public void appendChild(T child) {
        this.addChild(child);
        this.childrenChanged();
    }

    @Override
    public void appendChildren(List<T> list) {
        for (GenericTreeNode child : list) {
            this.addChild(child);
        }
        this.childrenChanged();
    }

    @Override
    public void insertChild(T child, int index) throws IndexOutOfBoundsException {
        if (child.getParent() != null) {
            child.getParent().removeChild(child);
        }
        child.setParent(this.myself);
        this.children.add(index, child);
        this.childrenChanged();
    }

    @Override
    public void removeAllChildren() {
        for (GenericTreeNode child : this.children) {
            child.setParent(null);
            child.setRoot(child);
        }
        this.children.clear();
        this.childrenChanged();
    }

    @Override
    public void removeChild(int index) throws IndexOutOfBoundsException {
        GenericTreeNode child = (GenericTreeNode)this.children.get(index);
        child.setParent(null);
        child.setRoot(child);
        this.children.remove(index);
        this.childrenChanged();
    }

    @Override
    public void removeChild(T child) throws IllegalArgumentException {
        if (!this.children.remove(child)) {
            throw new IllegalArgumentException("Given node is not a child of this node");
        }
        child.setParent(null);
        child.setRoot(child);
        this.childrenChanged();
    }

    @Override
    public T getChildAt(int index) throws IndexOutOfBoundsException {
        return (T)((GenericTreeNode)this.children.get(index));
    }

    @Override
    public int getIndex(T child) {
        if (child != null) {
            return this.children.indexOf(child);
        }
        throw new IllegalArgumentException("The child cannot be null");
    }

    @Override
    public T getPreviousSibling() {
        if (this.getParent() != null) {
            int index = this.getParent().getIndex(this.myself);
            if (index == 0) {
                return null;
            }
            return this.getParent().getChildAt(index - 1);
        }
        return null;
    }

    @Override
    public T getNextSibling() {
        if (this.getParent() != null) {
            int index = this.getParent().getIndex(this.myself);
            if (index == this.getParent().getChildCount() - 1) {
                return null;
            }
            return this.getParent().getChildAt(index + 1);
        }
        return null;
    }

    @Override
    public int getDepth() {
        return this.recursiveGetDepth(this.myself);
    }

    private int recursiveGetDepth(T root) {
        if (root.isLeaf()) {
            return 0;
        }
        int max = 0;
        for (GenericTreeNode child : root.getChildren()) {
            int cdepth = this.recursiveGetDepth(child);
            if (cdepth <= max) continue;
            max = cdepth;
        }
        return max + 1;
    }

    @Override
    public int getLeafCount() {
        return this.recursiveGetLeafCount(this.myself);
    }

    private int recursiveGetLeafCount(T root) {
        if (root.isLeaf()) {
            return 1;
        }
        int sum = 0;
        for (GenericTreeNode child : root.getChildren()) {
            sum += this.recursiveGetLeafCount(child);
        }
        return sum;
    }

    @Override
    public void childrenChanged() {
    }
}

