/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.impl;

import cz.vutbr.fit.layout.impl.BaseBoxTreeBuilder;
import cz.vutbr.fit.layout.impl.DefaultBox;
import cz.vutbr.fit.layout.impl.DefaultPage;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Color;
import cz.vutbr.fit.layout.model.Page;
import java.util.LinkedList;
import java.util.List;

public class PageBoxTreeBuilder
extends BaseBoxTreeBuilder {
    private DefaultPage page;

    public PageBoxTreeBuilder(boolean useVisualBounds, boolean preserveAux) {
        super(useVisualBounds, preserveAux);
    }

    public Page processPage(Page input, String label, String creator, String creatorParams) {
        this.page = this.createTree(input);
        this.page.setLabel(label);
        this.page.setCreator(creator);
        this.page.setCreatorParams(creatorParams);
        return this.page;
    }

    @Override
    public Page getPage() {
        return this.page;
    }

    private DefaultPage createTree(Page input) {
        DefaultPage page = new DefaultPage(input);
        page.setParentIri(input.getIri());
        LinkedList<Box> boxes = new LinkedList<Box>();
        this.createBoxTree(page.getRoot(), null, boxes);
        for (Box box : boxes) {
            ((DefaultBox)box).setIntrinsicParent((Box)box.getParent());
        }
        Box root = this.buildTree(boxes, Color.WHITE);
        page.setRoot(root);
        return page;
    }

    private Box createBoxTree(Box root, Box treeRoot, List<Box> target) {
        DefaultBox ret = new DefaultBox(root);
        ret.setId(ret.getOrder());
        ret.addUserAttribute("core.node.sameAs", root);
        target.add(ret);
        if (treeRoot == null) {
            ret.setRoot(ret);
            treeRoot = ret;
        }
        for (Box child : root.getChildren()) {
            ret.appendChild(this.createBoxTree(child, treeRoot, target));
        }
        return ret;
    }
}

