/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.impl;

import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.Metadata;
import java.util.Collection;
import java.util.Date;
import org.eclipse.rdf4j.model.IRI;

public abstract class BaseArtifact
implements Artifact {
    private IRI iri;
    private IRI parentIri;
    private String label;
    private Date createdOn;
    private String creator;
    private String creatorParams;
    private Collection<Metadata> metadata;

    public BaseArtifact(IRI parentIri) {
        this.parentIri = parentIri;
        this.createdOn = new Date();
    }

    public BaseArtifact(IRI parentIri, Artifact src) {
        this.label = src.getLabel() == null ? null : new String(src.getLabel());
        this.creator = src.getCreator() == null ? null : new String(src.getCreator());
        this.creatorParams = src.getCreatorParams() == null ? null : new String(src.getCreatorParams());
        this.createdOn = new Date();
    }

    @Override
    public IRI getIri() {
        return this.iri;
    }

    @Override
    public void setIri(IRI iri) {
        this.iri = iri;
    }

    @Override
    public IRI getParentIri() {
        return this.parentIri;
    }

    public void setParentIri(IRI parentIri) {
        this.parentIri = parentIri;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    @Override
    public String getCreatorParams() {
        return this.creatorParams;
    }

    public void setCreatorParams(String creatorParams) {
        this.creatorParams = creatorParams;
    }

    @Override
    public Collection<Metadata> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Collection<Metadata> metadata) {
        this.metadata = metadata;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.iri == null ? 0 : this.iri.hashCode());
        result = 31 * result + (this.parentIri == null ? 0 : this.parentIri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseArtifact other = (BaseArtifact)obj;
        if (this.iri == null ? other.iri != null : !this.iri.equals((Object)other.iri)) {
            return false;
        }
        return !(this.parentIri == null ? other.parentIri != null : !this.parentIri.equals((Object)other.parentIri));
    }
}

