/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.impl;

import cz.vutbr.fit.layout.impl.BaseArtifact;
import cz.vutbr.fit.layout.impl.DefaultArea;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTree;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.ontology.SEGM;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;

public class DefaultAreaTree
extends BaseArtifact
implements AreaTree {
    private int areaIdCnt = 1;
    private IRI pageIri;
    private Area root;

    public DefaultAreaTree(IRI pageIri) {
        super(pageIri);
        this.setPageIri(pageIri);
    }

    public DefaultAreaTree(IRI parentIri, IRI pageIri) {
        super(parentIri);
        this.setPageIri(pageIri);
    }

    public DefaultAreaTree(AreaTree src) {
        super(src.getParentIri());
        this.setPageIri(src.getPageIri());
        this.root = src.getRoot();
        this.updateNextAreaId();
    }

    @Override
    public IRI getArtifactType() {
        return SEGM.AreaTree;
    }

    @Override
    public IRI getPageIri() {
        return this.pageIri;
    }

    public void setPageIri(IRI pageIri) {
        this.pageIri = pageIri;
    }

    @Override
    public Area getRoot() {
        return this.root;
    }

    public void setRoot(Area root) {
        this.root = root;
        this.updateNextAreaId();
    }

    @Override
    public void updateTopologies() {
    }

    public String toString() {
        return "AreaTree [" + this.getIri() + "]";
    }

    @Override
    public Area getAreaAt(int x, int y) {
        return this.recursiveGetAreaAt(this.root, x, y);
    }

    private Area recursiveGetAreaAt(Area root, int x, int y) {
        if (root.getBounds().contains(x, y)) {
            for (int i = 0; i < root.getChildCount(); ++i) {
                Area ret = this.recursiveGetAreaAt((Area)root.getChildAt(i), x, y);
                if (ret == null) continue;
                return ret;
            }
            return root;
        }
        return null;
    }

    @Override
    public List<Area> getAreasAt(int x, int y) {
        ArrayList<Area> ret = new ArrayList<Area>();
        this.recursiveGetAreasAt(this.root, x, y, ret);
        return ret;
    }

    private void recursiveGetAreasAt(Area root, int x, int y, List<Area> dest) {
        if (root.getBounds().contains(x, y)) {
            dest.add(root);
            for (int i = 0; i < root.getChildCount(); ++i) {
                this.recursiveGetAreasAt((Area)root.getChildAt(i), x, y, dest);
            }
        }
    }

    @Override
    public Area getAreaByName(String name) {
        return this.recursiveGetAreaByName(this.root, name);
    }

    private Area recursiveGetAreaByName(Area root, String name) {
        if (root.toString().indexOf(name) != -1) {
            return root;
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            Area ret = this.recursiveGetAreaByName((Area)root.getChildAt(i), name);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    @Override
    public Area createArea(Rectangular r) {
        DefaultArea ret = new DefaultArea(r);
        ret.setId(this.getNextAreaId());
        ret.setAreaTree(this);
        ret.setPageIri(this.pageIri);
        return ret;
    }

    @Override
    public Area createArea(Box box) {
        DefaultArea ret = new DefaultArea(box);
        ret.setId(this.getNextAreaId());
        ret.setAreaTree(this);
        ret.setPageIri(this.pageIri);
        return ret;
    }

    @Override
    public Area createArea(Area other) {
        DefaultArea ret = new DefaultArea(other);
        ret.setId(this.getNextAreaId());
        ret.setAreaTree(this);
        ret.setPageIri(this.pageIri);
        return ret;
    }

    @Override
    public Area createArea(List<Box> boxes) {
        DefaultArea ret = new DefaultArea(boxes);
        ret.setId(this.getNextAreaId());
        ret.setAreaTree(this);
        ret.setPageIri(this.pageIri);
        return ret;
    }

    protected int getNextAreaId() {
        return this.areaIdCnt++;
    }

    public void setNextAreaId(int nextId) {
        this.areaIdCnt = nextId;
    }

    public void updateNextAreaId() {
        this.setNextAreaId(this.getMaxAreaId(this.root) + 1);
    }

    public int getMaxAreaId(Area root) {
        int max = root.getId();
        for (Area child : root.getChildren()) {
            int sub = this.getMaxAreaId(child);
            if (sub <= max) continue;
            max = sub;
        }
        return max;
    }
}

