/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.impl;

import cz.vutbr.fit.layout.impl.AreaListGridTopology;
import cz.vutbr.fit.layout.impl.BaseArtifact;
import cz.vutbr.fit.layout.impl.DefaultTextChunk;
import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTopology;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.ChunkSet;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.model.TextChunk;
import cz.vutbr.fit.layout.ontology.SEGM;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;

public class DefaultChunkSet
extends BaseArtifact
implements ChunkSet {
    private int idcnt = 1;
    private IRI areaTreeIri;
    private IRI pageIri;
    private Set<TextChunk> chunks;
    private AreaTopology topology;

    public DefaultChunkSet(IRI parentIri) {
        super(parentIri);
        this.setAreaTreeIri(parentIri);
        this.setTextChunks(new HashSet<TextChunk>());
    }

    public DefaultChunkSet(IRI parentIri, Set<TextChunk> chunks) {
        super(parentIri);
        this.setAreaTreeIri(parentIri);
        this.setTextChunks(chunks);
    }

    @Override
    public IRI getArtifactType() {
        return SEGM.ChunkSet;
    }

    @Override
    public IRI getAreaTreeIri() {
        return this.areaTreeIri;
    }

    public void setAreaTreeIri(IRI pageIri) {
        this.areaTreeIri = pageIri;
    }

    @Override
    public IRI getPageIri() {
        return this.pageIri;
    }

    public void setPageIri(IRI pageIri) {
        this.pageIri = pageIri;
    }

    @Override
    public Set<TextChunk> getTextChunks() {
        return this.chunks;
    }

    public void setTextChunks(Set<TextChunk> chunks) {
        this.chunks = chunks;
        this.invalidateTopology();
    }

    public void addTextChunk(TextChunk chunk) {
        this.chunks.add(chunk);
        this.invalidateTopology();
    }

    public void invalidateTopology() {
        this.topology = null;
    }

    public void updateTopology() {
        ArrayList<ContentRect> rects = new ArrayList<ContentRect>(this.chunks.size());
        rects.addAll(this.chunks);
        this.topology = new AreaListGridTopology(rects);
    }

    @Override
    public AreaTopology getTopology() {
        if (this.topology == null) {
            this.updateTopology();
        }
        return this.topology;
    }

    protected int getNextAreaId() {
        return this.idcnt++;
    }

    public void setNextAreaId(int nextId) {
        this.idcnt = nextId;
    }

    @Override
    public TextChunk createTextChunk(Rectangular r, Area sourceArea, Box sourceBox) {
        DefaultTextChunk chunk = new DefaultTextChunk(r, sourceArea, sourceBox);
        chunk.setId(this.getNextAreaId());
        return chunk;
    }
}

