/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.impl;

import cz.vutbr.fit.layout.model.Border;
import cz.vutbr.fit.layout.model.Color;
import cz.vutbr.fit.layout.model.ContentLine;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.fit.layout.model.TextStyle;
import java.util.HashMap;
import org.eclipse.rdf4j.model.IRI;

public class DefaultContentRect
implements ContentRect {
    private int id;
    private IRI pageIri;
    private Rectangular bounds;
    private Color backgroundColor;
    private byte[] backgroundImagePng;
    private boolean backgroundSeparated;
    private HashMap<String, Object> attributes;
    private TextStyle textStyle;
    private boolean textStyleComputed = false;
    private Border topBorder;
    private Border bottomBorder;
    private Border leftBorder;
    private Border rightBorder;
    private ContentLine line;

    public DefaultContentRect() {
        this.bounds = new Rectangular();
        this.textStyle = new TextStyle();
        this.topBorder = new Border();
        this.bottomBorder = new Border();
        this.leftBorder = new Border();
        this.rightBorder = new Border();
        this.attributes = new HashMap(1);
    }

    public DefaultContentRect(ContentRect src) {
        this.pageIri = src.getPageIri();
        this.bounds = new Rectangular(src.getBounds());
        this.backgroundColor = src.getBackgroundColor() == null ? null : new Color(src.getBackgroundColor().getRed(), src.getBackgroundColor().getGreen(), src.getBackgroundColor().getBlue());
        this.textStyle = new TextStyle(src.getTextStyle());
        this.topBorder = src.getBorderStyle(Border.Side.TOP);
        this.bottomBorder = src.getBorderStyle(Border.Side.BOTTOM);
        this.leftBorder = src.getBorderStyle(Border.Side.LEFT);
        this.rightBorder = src.getBorderStyle(Border.Side.RIGHT);
        this.backgroundSeparated = src.isBackgroundSeparated();
        this.attributes = new HashMap(1);
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public IRI getPageIri() {
        return this.pageIri;
    }

    public void setPageIri(IRI pageIri) {
        this.pageIri = pageIri;
    }

    @Override
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Override
    public byte[] getBackgroundImagePng() {
        return this.backgroundImagePng;
    }

    @Override
    public boolean hasBackground() {
        return this.getBackgroundColor() != null || this.getBackgroundImagePng() != null;
    }

    public void setBackgroundImagePng(byte[] backgroundImagePng) {
        this.backgroundImagePng = backgroundImagePng;
    }

    @Override
    public boolean isBackgroundSeparated() {
        return this.backgroundSeparated;
    }

    @Override
    public void setBackgroundSeparated(boolean backgroundSeparated) {
        this.backgroundSeparated = backgroundSeparated;
    }

    @Override
    public TextStyle getTextStyle() {
        if (!this.textStyleComputed) {
            this.textStyleComputed = true;
            this.recomputeTextStyle();
        }
        return this.textStyle;
    }

    protected void recomputeTextStyle() {
    }

    public void setTextStyle(TextStyle textStyle) {
        this.textStyle = textStyle;
    }

    @Override
    public ContentLine getLine() {
        return this.line;
    }

    @Override
    public void setLine(ContentLine line) {
        this.line = line;
    }

    @Override
    public int getTopBorder() {
        return this.topBorder.getWidth();
    }

    @Override
    public int getBottomBorder() {
        return this.bottomBorder.getWidth();
    }

    @Override
    public int getLeftBorder() {
        return this.leftBorder.getWidth();
    }

    @Override
    public int getRightBorder() {
        return this.rightBorder.getWidth();
    }

    @Override
    public boolean hasTopBorder() {
        return this.topBorder.getStyle() != Border.Style.NONE && this.topBorder.getColor().getAlpha() > 0;
    }

    @Override
    public boolean hasBottomBorder() {
        return this.bottomBorder.getStyle() != Border.Style.NONE && this.bottomBorder.getColor().getAlpha() > 0;
    }

    @Override
    public boolean hasLeftBorder() {
        return this.leftBorder.getStyle() != Border.Style.NONE && this.leftBorder.getColor().getAlpha() > 0;
    }

    @Override
    public boolean hasRightBorder() {
        return this.rightBorder.getStyle() != Border.Style.NONE && this.rightBorder.getColor().getAlpha() > 0;
    }

    @Override
    public Border getBorderStyle(Border.Side side) {
        switch (side) {
            case TOP: {
                return this.topBorder;
            }
            case LEFT: {
                return this.leftBorder;
            }
            case BOTTOM: {
                return this.bottomBorder;
            }
            case RIGHT: {
                return this.rightBorder;
            }
        }
        return null;
    }

    public void setBorderStyle(Border.Side side, Border style) {
        switch (side) {
            case TOP: {
                this.topBorder = new Border(style);
                break;
            }
            case LEFT: {
                this.leftBorder = new Border(style);
                break;
            }
            case BOTTOM: {
                this.bottomBorder = new Border(style);
                break;
            }
            case RIGHT: {
                this.rightBorder = new Border(style);
            }
        }
    }

    @Override
    public Rectangular getBounds() {
        return this.bounds;
    }

    @Override
    public void setBounds(Rectangular bounds) {
        this.bounds = bounds;
    }

    @Override
    public int getBorderCount() {
        int bcnt = 0;
        if (this.hasTopBorder()) {
            ++bcnt;
        }
        if (this.hasBottomBorder()) {
            ++bcnt;
        }
        if (this.hasLeftBorder()) {
            ++bcnt;
        }
        if (this.hasRightBorder()) {
            ++bcnt;
        }
        return bcnt;
    }

    @Override
    public int getX1() {
        return this.getBounds().getX1();
    }

    @Override
    public int getY1() {
        return this.getBounds().getY1();
    }

    @Override
    public int getX2() {
        return this.getBounds().getX2();
    }

    @Override
    public int getY2() {
        return this.getBounds().getY2();
    }

    @Override
    public int getWidth() {
        return this.getBounds().getWidth();
    }

    @Override
    public int getHeight() {
        return this.getBounds().getHeight();
    }

    @Override
    public void move(int xofs, int yofs) {
        this.getBounds().move(xofs, yofs);
    }

    @Override
    public <P> P getUserAttribute(String name, Class<P> clazz) {
        return clazz.cast(this.attributes.get(name));
    }

    @Override
    public void addUserAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultContentRect other = (DefaultContentRect)obj;
        return this.id == other.id;
    }
}

