/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.api;

import cz.vutbr.fit.layout.model.Area;
import cz.vutbr.fit.layout.model.AreaTopology;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.model.Rectangular;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AreaUtils {
    public static boolean isNeighbor(Area a1, Area a2) {
        if (AreaUtils.isOnSameLine(a1, a2)) {
            return true;
        }
        int dy = a2.getBounds().getY1() - a1.getBounds().getY2();
        if (dy < 0) {
            dy = a1.getBounds().getY1() - a2.getBounds().getY2();
        }
        return dy < a1.getBounds().getHeight() / 2;
    }

    public static boolean isOnSameLine(ContentRect a1, ContentRect a2) {
        return AreaUtils.isOnSameLine(a1.getBounds(), a2.getBounds());
    }

    public static boolean isOnSameLine(Rectangular r1, Rectangular r2) {
        Rectangular shrt;
        Rectangular tall;
        if (r2.getHeight() > r1.getHeight()) {
            tall = r2;
            shrt = r1;
        } else {
            tall = r1;
            shrt = r2;
        }
        return tall.getY1() < shrt.midY() && tall.getY2() > shrt.midY();
    }

    public static boolean isInSameColumn(Area a1, Area a2, AreaTopology topology) {
        Rectangular gp1 = topology.getPosition(a1);
        Rectangular gp2 = topology.getPosition(a2);
        return gp1.getX1() == gp2.getX1();
    }

    public static boolean isAligned(Area a1, Area a2, AreaTopology topology) {
        Rectangular gp1 = topology.getPosition(a1);
        Rectangular gp2 = topology.getPosition(a2);
        return gp1.getX1() == gp2.getX1() || gp1.getY1() == gp2.getY1();
    }

    public static boolean isLink(Area a) {
        for (Box box : a.getBoxes()) {
            if (box.getAttribute("href") == null) continue;
            return true;
        }
        return false;
    }

    public static void findAreasBeforeAfter(Area a, AreaTopology topology, List<ContentRect> destBefore, List<ContentRect> destAfter) {
        Rectangular r;
        Collection<ContentRect> cands;
        int y;
        Rectangular gpa = topology.getPosition(a);
        int x = gpa.getX1() - 1;
        boolean breakFound = false;
        while (x >= 0 && !breakFound) {
            int minX = x;
            for (y = gpa.getY1(); y <= gpa.getY2(); ++y) {
                cands = topology.findAllAreasAt(x, y);
                for (ContentRect cand : cands) {
                    if (AreaUtils.isOnSameLine(cand, a)) {
                        destBefore.add(0, a);
                        r = topology.getPosition(cand);
                        minX = Math.min(minX, r.getX1());
                        continue;
                    }
                    breakFound = true;
                }
            }
            x = minX - 1;
        }
        x = gpa.getX2() + 1;
        breakFound = false;
        while (x < topology.getTopologyWidth() && !breakFound) {
            int maxX = x;
            for (y = gpa.getY1(); y <= gpa.getY2(); ++y) {
                cands = topology.findAllAreasAt(x, y);
                for (ContentRect cand : cands) {
                    if (AreaUtils.isOnSameLine(cand, a)) {
                        destAfter.add(a);
                        r = topology.getPosition(cand);
                        maxX = Math.max(maxX, r.getX2());
                        continue;
                    }
                    breakFound = true;
                }
            }
            x = maxX + 1;
        }
    }

    public static void findAreasBelow(Area a, AreaTopology topology, List<ContentRect> destBelow) {
        Rectangular gpa = topology.getPosition(a);
        boolean found = false;
        for (int y = gpa.getY2() + 1; y < topology.getTopologyHeight() && !found; ++y) {
            int x = gpa.getX1();
            while (x <= gpa.getX2()) {
                int maxX = x;
                Collection<ContentRect> cands = topology.findAllAreasAt(x, y);
                if (!cands.isEmpty()) {
                    for (ContentRect cand : cands) {
                        destBelow.add(cand);
                        Rectangular r = topology.getPosition(cand);
                        maxX = Math.max(maxX, r.getX2());
                    }
                    found = true;
                }
                x = maxX + 1;
            }
        }
    }

    public static boolean intersectsWithAny(Area a, Collection<Area> col) {
        for (Area b : col) {
            if (!a.getBounds().intersects(b.getBounds())) continue;
            return true;
        }
        return false;
    }

    public static boolean areasOverlap(Collection<Area> areas1, Collection<Area> areas2, double minPercentage) {
        for (Area a1 : areas1) {
            for (Area a2 : areas2) {
                if (!AreaUtils.areasOverlap(a1, a2, minPercentage)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean areasOverlap(Area a1, Collection<Area> areas2, double minPercentage) {
        for (Area a2 : areas2) {
            if (!AreaUtils.areasOverlap(a1, a2, minPercentage)) continue;
            return true;
        }
        return false;
    }

    public static boolean areasOverlap(Area a1, Area a2, double minPercentage) {
        Rectangular intr = a1.getBounds().intersection(a2.getBounds());
        if (!intr.isEmpty()) {
            int shared = intr.getArea();
            double sp1 = (double)shared / (double)a1.getBounds().getArea();
            double sp2 = (double)shared / (double)a2.getBounds().getArea();
            return sp1 >= minPercentage || sp2 >= minPercentage;
        }
        return false;
    }

    public static List<ContentRect> getChildrenAsContentRects(Area parent) {
        ArrayList<ContentRect> children = new ArrayList<ContentRect>(parent.getChildCount());
        children.addAll(parent.getChildren());
        return children;
    }

    public static float statRound(float value) {
        float f = 100000.0f;
        return (float)Math.round(value * 100000.0f) / 100000.0f;
    }
}

