/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.impl;

import cz.vutbr.fit.layout.api.OutputDisplay;
import cz.vutbr.fit.layout.impl.AreaGrid;
import cz.vutbr.fit.layout.model.AreaTopology;
import cz.vutbr.fit.layout.model.ContentRect;
import cz.vutbr.fit.layout.model.Rectangular;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AreaListGridTopology
implements AreaTopology {
    private Collection<ContentRect> areas;
    private Rectangular abspos;
    private Map<ContentRect, Rectangular> positions;
    private Map<Coords, Set<ContentRect>> index;
    private AreaGrid grid;

    public AreaListGridTopology(Collection<ContentRect> areas) {
        this(areas, true);
    }

    public AreaListGridTopology(Collection<ContentRect> areas, boolean doInit) {
        this.areas = areas;
        if (doInit) {
            this.update();
        }
    }

    @Override
    public Collection<ContentRect> getAreas() {
        return this.areas;
    }

    public void setAreas(List<ContentRect> areas) {
        this.areas = areas;
    }

    @Override
    public int getTopologyWidth() {
        return this.grid.getWidth();
    }

    @Override
    public int getTopologyHeight() {
        return this.grid.getHeight();
    }

    @Override
    public Rectangular getTopologyPosition() {
        return this.grid.getAbsolutePosition();
    }

    @Override
    public Rectangular getPosition(ContentRect area) {
        return this.positions.get(area);
    }

    @Override
    public void setPosition(ContentRect area, Rectangular gp) {
        this.positions.put(area, gp);
    }

    @Override
    public Map<ContentRect, Rectangular> getPositionMap() {
        return this.positions;
    }

    @Override
    public ContentRect findAreaAt(int x, int y) {
        Set<ContentRect> areas = this.index.get(new Coords(x, y));
        if (areas != null && !areas.isEmpty()) {
            return areas.iterator().next();
        }
        return null;
    }

    @Override
    public Collection<ContentRect> findAllAreasAt(int x, int y) {
        Set<ContentRect> areas = this.index.get(new Coords(x, y));
        return areas == null ? Collections.emptyList() : areas;
    }

    @Override
    public Collection<ContentRect> findAllAreasIntersecting(Rectangular r) {
        ArrayList<ContentRect> ret = new ArrayList<ContentRect>();
        for (Map.Entry<ContentRect, Rectangular> entry : this.positions.entrySet()) {
            if (!entry.getValue().intersects(r)) continue;
            ret.add(entry.getKey());
        }
        return ret;
    }

    @Override
    public Rectangular toPixelPosition(Rectangular gp) {
        return new Rectangular(this.grid.getColOfs(gp.getX1()), this.grid.getRowOfs(gp.getY1()), this.grid.getColOfs(gp.getX2() + 1) - 1, this.grid.getRowOfs(gp.getY2() + 1) - 1);
    }

    @Override
    public Rectangular toPixelPositionAbsolute(Rectangular gp) {
        Rectangular ret = new Rectangular(this.grid.getColOfs(gp.getX1()), this.grid.getRowOfs(gp.getY1()), this.grid.getColOfs(gp.getX2() + 1) - 1, this.grid.getRowOfs(gp.getY2() + 1) - 1);
        ret.move(this.grid.getAbsolutePosition().getX1(), this.grid.getAbsolutePosition().getY1());
        return ret;
    }

    @Override
    public int toTopologyX(int pixelX) {
        return this.grid.findCellX(pixelX);
    }

    @Override
    public int toTopologyY(int pixelY) {
        return this.grid.findCellY(pixelY);
    }

    @Override
    public void update() {
        this.abspos = this.computeAreaBounds();
        this.positions = new HashMap<ContentRect, Rectangular>(this.areas.size());
        for (ContentRect contentRect : this.areas) {
            this.positions.put(contentRect, new Rectangular());
        }
        this.grid = new AreaGrid(this.abspos, this.areas, this);
        this.index = new HashMap<Coords, Set<ContentRect>>(this.positions.size());
        for (Map.Entry entry : this.positions.entrySet()) {
            this.addToIndex((ContentRect)entry.getKey(), (Rectangular)entry.getValue());
        }
    }

    @Override
    public void drawLayout(OutputDisplay disp) {
        Graphics2D ig = disp.getGraphics();
        Color c = ig.getColor();
        ig.setColor(Color.BLUE);
        int xo = this.abspos.getX1();
        for (int i = 1; i <= this.grid.getWidth(); ++i) {
            ig.drawLine(xo += this.grid.getCols()[i - 1], this.abspos.getY1(), xo, this.abspos.getY2());
        }
        int yo = this.abspos.getY1();
        for (int i = 0; i < this.grid.getHeight(); ++i) {
            ig.drawLine(this.abspos.getX1(), yo += this.grid.getRows()[i], this.abspos.getX2(), yo);
        }
        ig.setColor(c);
    }

    protected Rectangular computeAreaBounds() {
        Rectangular ret = null;
        for (ContentRect a : this.areas) {
            if (ret == null) {
                ret = new Rectangular(a.getBounds());
                continue;
            }
            ret.expandToEnclose(a.getBounds());
        }
        return ret;
    }

    private void addToIndex(ContentRect a, Rectangular gp) {
        for (int x = gp.getX1(); x <= gp.getX2(); ++x) {
            for (int y = gp.getY1(); y <= gp.getY2(); ++y) {
                Coords c = new Coords(x, y);
                Set<ContentRect> careas = this.index.get(c);
                if (careas == null) {
                    careas = new HashSet<ContentRect>();
                    this.index.put(c, careas);
                }
                careas.add(a);
            }
        }
    }

    private static class Coords {
        int x;
        int y;

        public Coords(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.x;
            result = 31 * result + this.y;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Coords other = (Coords)obj;
            if (this.x != other.x) {
                return false;
            }
            return this.y == other.y;
        }
    }
}

