/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.provider;

import cz.vutbr.fit.layout.api.ServiceException;
import cz.vutbr.fit.layout.impl.BaseArtifactService;
import cz.vutbr.fit.layout.impl.PageBoxTreeBuilder;
import cz.vutbr.fit.layout.model.Artifact;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.ontology.BOX;
import org.eclipse.rdf4j.model.IRI;

public class VisualBoxTreeProvider
extends BaseArtifactService {
    @Override
    public String getId() {
        return "FitLayout.VisualBoxTree";
    }

    @Override
    public String getName() {
        return "Visual box tree provider";
    }

    @Override
    public String getDescription() {
        return "Creates a visual box tree from another box tree";
    }

    @Override
    public IRI getConsumes() {
        return BOX.Page;
    }

    @Override
    public IRI getProduces() {
        return BOX.Page;
    }

    @Override
    public Artifact process(Artifact input) throws ServiceException {
        return this.createVisualTree((Page)input);
    }

    private Page createVisualTree(Page input) {
        PageBoxTreeBuilder builder = new PageBoxTreeBuilder(true, false);
        Object label = input.getLabel() == null ? "[visual tree]" : "[V] " + input.getLabel();
        return builder.processPage(input, (String)label, this.getId(), null);
    }
}

