/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.api;

import cz.vutbr.fit.layout.api.AreaTreeOperator;
import cz.vutbr.fit.layout.api.ArtifactRepository;
import cz.vutbr.fit.layout.api.ArtifactService;
import cz.vutbr.fit.layout.api.Parameter;
import cz.vutbr.fit.layout.api.ParametrizedOperation;
import cz.vutbr.fit.layout.api.Service;
import cz.vutbr.fit.layout.impl.DefaultArtifactRepository;
import cz.vutbr.fit.layout.model.Artifact;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.IRI;

public class ServiceManager {
    private ArtifactRepository artifactRepository;
    private Map<String, ArtifactService> artifactServices;
    private Map<String, AreaTreeOperator> operators;
    private Map<String, ParametrizedOperation> parametrizedServices;

    public static ServiceManager create() {
        ServiceManager mgr = new ServiceManager();
        mgr.initEmpty();
        return mgr;
    }

    protected void initEmpty() {
        this.artifactRepository = new DefaultArtifactRepository();
        this.parametrizedServices = new HashMap<String, ParametrizedOperation>();
        this.artifactServices = new HashMap<String, ArtifactService>();
        this.operators = new HashMap<String, AreaTreeOperator>();
    }

    public ArtifactRepository getArtifactRepository() {
        return this.artifactRepository;
    }

    public void setArtifactRepository(ArtifactRepository repository) {
        this.artifactRepository = repository;
    }

    public void addArtifactService(ArtifactService op) {
        this.addTypedOperation(op, this.artifactServices);
    }

    public Map<String, ArtifactService> findArtifactSevices() {
        return this.artifactServices;
    }

    public Map<String, ArtifactService> findArtifactProviders(IRI artifactType) {
        return this.artifactServices.entrySet().stream().filter(x -> artifactType.equals((Object)((ArtifactService)x.getValue()).getProduces())).collect(Collectors.toMap(x -> (String)x.getKey(), x -> (ArtifactService)x.getValue()));
    }

    public void addAreaTreeOperator(AreaTreeOperator op) {
        this.addTypedOperation(op, this.operators);
    }

    public Map<String, AreaTreeOperator> findAreaTreeOperators() {
        return this.operators;
    }

    public Artifact applyArtifactService(String serviceId, Map<String, Object> params, Artifact inputArtifact) {
        ParametrizedOperation op = this.findParmetrizedService(serviceId);
        if (op == null) {
            throw new IllegalArgumentException("No such service: " + serviceId);
        }
        if (!(op instanceof ArtifactService)) {
            throw new IllegalArgumentException("Not an ArtifactService: " + serviceId);
        }
        if (params != null) {
            ServiceManager.setServiceParams(op, params);
        }
        return ((ArtifactService)((Object)op)).process(inputArtifact);
    }

    public static void setServiceParams(ParametrizedOperation op, Map<String, Object> params) {
        if (params != null) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                op.setParam(entry.getKey(), entry.getValue());
            }
        }
    }

    public static Map<String, Object> getServiceParams(ParametrizedOperation op) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (Parameter param : op.getParams()) {
            ret.put(param.getName(), op.getParam(param.getName()));
        }
        return ret;
    }

    public Map<String, ParametrizedOperation> getParametrizedServices() {
        return this.parametrizedServices;
    }

    public ParametrizedOperation findParmetrizedService(String id) {
        if (this.parametrizedServices == null) {
            return null;
        }
        return this.parametrizedServices.get(id);
    }

    public void addService(Service op) {
        op.setServiceManager(this);
        if (op instanceof ParametrizedOperation) {
            this.addParametrizedService(op.getId(), (ParametrizedOperation)((Object)op));
        }
    }

    private <T extends Service> void addTypedOperation(T op, Map<String, T> dest) {
        this.addService(op);
        dest.put(op.getId(), op);
    }

    private void addParametrizedService(String id, ParametrizedOperation op) {
        this.parametrizedServices.put(id, op);
    }

    public <T> T findByClass(Collection<?> services, Class<T> clazz) {
        for (Object serv : services) {
            if (!clazz.isInstance(serv)) continue;
            return clazz.cast(serv);
        }
        return null;
    }
}

